/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.instrumentation;

import com.netflix.archaius.api.PropertyDetails;
import com.netflix.archaius.instrumentation.PropertiesInstrumentationData;
import com.netflix.archaius.instrumentation.PropertyUsageData;
import com.netflix.archaius.instrumentation.PropertyUsageEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessMonitorUtil
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AccessMonitorUtil.class);
    private final ConcurrentHashMap<String, PropertyUsageData> propertyUsageMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> stackTrace = new ConcurrentHashMap();
    private static final AtomicInteger counter = new AtomicInteger();
    private final ScheduledExecutorService executor;
    private final Consumer<PropertiesInstrumentationData> dataFlushConsumer;
    private final boolean recordStackTrace;

    public static Builder builder() {
        return new Builder();
    }

    private AccessMonitorUtil(Consumer<PropertiesInstrumentationData> dataFlushConsumer, boolean recordStackTrace) {
        this.dataFlushConsumer = dataFlushConsumer;
        this.recordStackTrace = recordStackTrace;
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread2 = Executors.defaultThreadFactory().newThread(runnable);
            thread2.setDaemon(true);
            thread2.setName(String.format("Archaius-Instrumentation-Flusher-%d", counter.incrementAndGet()));
            return thread2;
        });
    }

    private void startFlushing(int initialDelay, int period) {
        if (!this.flushingEnabled()) {
            LOG.info("Property usage data is being captured, but not flushed as there is no consumer specified.");
        } else {
            this.executor.scheduleWithFixedDelay(this::flushUsageData, initialDelay, period, TimeUnit.SECONDS);
        }
    }

    private void flushUsageData() {
        try {
            if (this.flushingEnabled()) {
                this.dataFlushConsumer.accept(new PropertiesInstrumentationData(this.getAndClearUsageMap()));
            }
        }
        catch (Exception e2) {
            LOG.warn("Failed to flush property instrumentation data", e2);
        }
    }

    public void merge(AccessMonitorUtil accessMonitorUtil) {
        for (Map.Entry<String, PropertyUsageData> entry : accessMonitorUtil.propertyUsageMap.entrySet()) {
            this.propertyUsageMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : accessMonitorUtil.stackTrace.entrySet()) {
            this.stackTrace.merge(entry.getKey(), (Integer)entry.getValue(), Integer::sum);
        }
    }

    public void registerUsage(PropertyDetails propertyDetails) {
        this.propertyUsageMap.putIfAbsent(propertyDetails.getId(), new PropertyUsageData(this.createEventList(new PropertyUsageEvent(System.currentTimeMillis()))));
        if (this.recordStackTrace) {
            String trace = Arrays.toString(Thread.currentThread().getStackTrace());
            this.stackTrace.merge(trace, 1, (v1, v2) -> v1 + 1);
        }
    }

    private List<PropertyUsageEvent> createEventList(PropertyUsageEvent event) {
        ArrayList<PropertyUsageEvent> list = new ArrayList<PropertyUsageEvent>();
        list.add(event);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PropertyUsageData> getAndClearUsageMap() {
        ConcurrentHashMap<String, PropertyUsageData> concurrentHashMap = this.propertyUsageMap;
        synchronized (concurrentHashMap) {
            Map<String, PropertyUsageData> ret = this.getUsageMapImmutable();
            this.propertyUsageMap.clear();
            return ret;
        }
    }

    public Map<String, PropertyUsageData> getUsageMapImmutable() {
        return Collections.unmodifiableMap(new HashMap<String, PropertyUsageData>(this.propertyUsageMap));
    }

    public Map<String, Integer> getStackTracesImmutable() {
        return Collections.unmodifiableMap(new HashMap<String, Integer>(this.stackTrace));
    }

    public boolean flushingEnabled() {
        return this.dataFlushConsumer != null;
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.flushUsageData();
    }

    public static class Builder {
        private Consumer<PropertiesInstrumentationData> dataFlushConsumer = null;
        private boolean recordStackTrace = false;
        private int initialFlushDelaySeconds = 30;
        private int flushPeriodSeconds = 120;

        public Builder setDataFlushConsumer(Consumer<PropertiesInstrumentationData> dataFlushConsumer) {
            this.dataFlushConsumer = dataFlushConsumer;
            return this;
        }

        public Builder setRecordStackTrace(boolean recordStackTrace) {
            this.recordStackTrace = recordStackTrace;
            return this;
        }

        public Builder setInitialFlushDelaySeconds(int initialFlushDelaySeconds) {
            this.initialFlushDelaySeconds = initialFlushDelaySeconds;
            return this;
        }

        public Builder setFlushPeriodSeconds(int flushPeriodSeconds) {
            this.flushPeriodSeconds = flushPeriodSeconds;
            return this;
        }

        public AccessMonitorUtil build() {
            AccessMonitorUtil accessMonitorUtil = new AccessMonitorUtil(this.dataFlushConsumer, this.recordStackTrace);
            accessMonitorUtil.startFlushing(this.initialFlushDelaySeconds, this.flushPeriodSeconds);
            return accessMonitorUtil;
        }
    }
}

