/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.readers;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigReader;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.readers.URLConfigReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigReader
implements ConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesConfigReader.class);
    private static final String[] INCLUDE_KEYS = new String[]{"@next", "netflixconfiguration.properties.nextLoad"};
    private static final String SUFFIX = ".properties";

    @Override
    public Config load(ClassLoader loader, String resourceName, StrInterpolator strInterpolator, StrInterpolator.Lookup lookup) throws ConfigException {
        DefaultCompositeConfig.Builder builder = DefaultCompositeConfig.builder();
        Collection<URL> resources = PropertiesConfigReader.getResources(loader, resourceName);
        if (resources.size() > 1) {
            LOG.warn("Multiple resource files found for {}. {}.  All resources will be loaded with override order undefined.", (Object)resourceName, (Object)resources);
        }
        for (URL url : resources) {
            builder.withConfig(url.toString(), this.load(loader, url, strInterpolator, lookup));
        }
        CompositeConfig config = builder.build();
        if (config.getConfigNames().isEmpty()) {
            throw new ConfigException("No resources found for '" + resourceName + SUFFIX + "'");
        }
        return config;
    }

    @Override
    public Config load(ClassLoader loader, URL url, StrInterpolator strInterpolator, StrInterpolator.Lookup lookup) throws ConfigException {
        Properties props = new Properties();
        this.internalLoad(props, new HashSet<String>(), loader, url, strInterpolator, lookup);
        return MapConfig.from(props);
    }

    private void internalLoad(Properties props, Set<String> seenUrls, ClassLoader loader, URL url, StrInterpolator strInterpolator, StrInterpolator.Lookup lookup) {
        LOG.debug("Attempting to load : {}", (Object)url.toExternalForm());
        if (!seenUrls.contains(url.toExternalForm())) {
            seenUrls.add(url.toExternalForm());
            try {
                Map<String, String> p = new URLConfigReader(url).call().getToAdd();
                LOG.debug("Loaded : {}", (Object)url.toExternalForm());
                props.putAll(p);
                for (String nextLoadPropName : INCLUDE_KEYS) {
                    String nextLoadValue = (String)props.remove(nextLoadPropName);
                    if (nextLoadValue == null) continue;
                    for (String urlString : nextLoadValue.split(",")) {
                        for (URL nextUrl : PropertiesConfigReader.getResources(loader, strInterpolator.create(lookup).resolve(urlString))) {
                            this.internalLoad(props, seenUrls, loader, nextUrl, strInterpolator, lookup);
                        }
                    }
                }
            }
            catch (IOException e2) {
                LOG.debug("Unable to load configuration file {}. {}", (Object)url, (Object)e2.getMessage());
            }
        } else {
            LOG.debug("Circular dependency trying to load url : {}", (Object)url.toExternalForm());
        }
    }

    @Override
    public boolean canLoad(ClassLoader loader, String name2) {
        return PropertiesConfigReader.getResources(loader, name2) != null;
    }

    @Override
    public boolean canLoad(ClassLoader loader, URL uri) {
        return uri.getPath().endsWith(SUFFIX);
    }

    private static Collection<URL> getResources(ClassLoader loader, String resourceName) {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        if (!resourceName.endsWith(SUFFIX)) {
            resourceName = resourceName + SUFFIX;
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader != null) {
            try {
                resources.addAll(Collections.list(loader.getResources(resourceName)));
            }
            catch (IOException e2) {
                LOG.debug("Failed to load resources for {}", (Object)resourceName, (Object)e2);
            }
        }
        try {
            resources.addAll(Collections.list(ClassLoader.getSystemResources(resourceName)));
        }
        catch (IOException e3) {
            LOG.debug("Failed to load resources for {}", (Object)resourceName, (Object)e3);
        }
        try {
            resourceName = URLDecoder.decode(resourceName, "UTF-8");
            File file2 = new File(resourceName);
            if (file2.exists()) {
                resources.add(file2.toURI().toURL());
            }
        }
        catch (Exception e4) {
            LOG.debug("Failed to load resources for {}", (Object)resourceName, (Object)e4);
        }
        return resources;
    }
}

