/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.internal.discovery;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import io.mantisrx.discovery.proto.AppJobClustersMap;
import io.mantisrx.discovery.proto.JobDiscoveryInfo;
import io.mantisrx.discovery.proto.StreamJobClusterMap;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.internal.discovery.MantisJobDiscovery;
import io.mantisrx.publish.internal.discovery.mantisapi.MantisApiClient;
import io.mantisrx.publish.internal.exceptions.NonRetryableException;
import io.mantisrx.publish.internal.metrics.SpectatorUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisJobDiscoveryCachingImpl
implements MantisJobDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(MantisJobDiscoveryCachingImpl.class);
    private static final String JOB_CLUSTER_LOOKUP_FAILED = "JobClusterLookupFailed";
    private final MantisApiClient mantisApiClient;
    private final MrePublishConfiguration configuration;
    private final ConcurrentMap<String, AtomicLong> lastFetchTimeMs = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, Optional<JobDiscoveryInfo>> jobClusterDiscoveryInfoMap = new ConcurrentHashMap<String, Optional<JobDiscoveryInfo>>();
    private final ConcurrentMap<String, AppJobClustersMap> appJobClusterMapping = new ConcurrentHashMap<String, AppJobClustersMap>();
    private final Counter jobDiscoveryRefreshSuccess;
    private final Counter jobDiscoveryRefreshFailed;
    private final Counter jobClusterMappingRefreshSuccess;
    private final Counter jobClusterMappingRefreshFailed;

    public MantisJobDiscoveryCachingImpl(MrePublishConfiguration configuration, Registry registry, MantisApiClient mantisApiClient) {
        this.configuration = configuration;
        this.mantisApiClient = mantisApiClient;
        this.jobDiscoveryRefreshSuccess = SpectatorUtils.buildAndRegisterCounter(registry, "jobDiscoveryRefreshSuccess");
        this.jobDiscoveryRefreshFailed = SpectatorUtils.buildAndRegisterCounter(registry, "jobDiscoveryRefreshFailed");
        this.jobClusterMappingRefreshSuccess = SpectatorUtils.buildAndRegisterCounter(registry, "jobClusterMappingRefreshSuccess");
        this.jobClusterMappingRefreshFailed = SpectatorUtils.buildAndRegisterCounter(registry, "jobClusterMappingRefreshFailed");
    }

    void refreshDiscoveryInfo(String jobClusterName) {
        CompletableFuture<JobDiscoveryInfo> jobDiscoveryInfoF = this.mantisApiClient.jobDiscoveryInfo(jobClusterName);
        if (this.jobClusterDiscoveryInfoMap.containsKey(jobClusterName)) {
            jobDiscoveryInfoF.whenCompleteAsync((jdi, t) -> {
                if (jdi != null) {
                    this.jobClusterDiscoveryInfoMap.put(jobClusterName, Optional.ofNullable(jdi));
                    this.jobDiscoveryRefreshSuccess.increment();
                } else {
                    logger.info("failed to refresh job discovery info, will serve old job discovery info");
                    this.jobDiscoveryRefreshFailed.increment();
                }
            });
        } else {
            try {
                JobDiscoveryInfo jobDiscoveryInfo = jobDiscoveryInfoF.get(1L, TimeUnit.SECONDS);
                this.jobClusterDiscoveryInfoMap.put(jobClusterName, Optional.ofNullable(jobDiscoveryInfo));
                this.jobDiscoveryRefreshSuccess.increment();
            }
            catch (InterruptedException e2) {
                logger.warn("interrupted on job discovery fetch {}", (Object)jobClusterName, (Object)e2);
                this.jobDiscoveryRefreshFailed.increment();
            }
            catch (ExecutionException e3) {
                this.jobDiscoveryRefreshFailed.increment();
                if (e3.getCause() instanceof NonRetryableException) {
                    logger.warn("non retryable exception on job discovery fetch {}, update cache to avoid blocking refresh in future", (Object)jobClusterName, (Object)e3.getCause());
                    this.jobClusterDiscoveryInfoMap.put(jobClusterName, Optional.empty());
                } else {
                    logger.warn("caught exception on job discovery fetch {}", (Object)jobClusterName, (Object)e3.getCause());
                }
            }
            catch (TimeoutException e4) {
                this.jobDiscoveryRefreshFailed.increment();
                logger.warn("timed out on job discovery fetch {}", (Object)jobClusterName, (Object)e4);
            }
        }
    }

    private boolean shouldRefreshWorkers(String jobCluster) {
        this.lastFetchTimeMs.putIfAbsent(jobCluster, new AtomicLong(0L));
        long lastFetchMs = ((AtomicLong)this.lastFetchTimeMs.get(jobCluster)).get();
        return System.currentTimeMillis() - lastFetchMs > (long)(this.configuration.jobDiscoveryRefreshIntervalSec() * 1000);
    }

    @Override
    public Optional<JobDiscoveryInfo> getCurrentJobWorkers(String jobClusterName) {
        if (this.shouldRefreshWorkers(jobClusterName)) {
            this.refreshDiscoveryInfo(jobClusterName);
            ((AtomicLong)this.lastFetchTimeMs.get(jobClusterName)).set(System.currentTimeMillis());
        }
        return this.jobClusterDiscoveryInfoMap.getOrDefault(jobClusterName, Optional.empty());
    }

    @Override
    public Map<String, String> getStreamNameToJobClusterMapping(String app) {
        String appName = this.configuration.appName();
        Optional<AppJobClustersMap> jobClusterMappingsO = this.getJobClusterMappings(appName);
        if (jobClusterMappingsO.isPresent()) {
            AppJobClustersMap appJobClustersMap = jobClusterMappingsO.get();
            StreamJobClusterMap streamJobClusterMap = appJobClustersMap.getStreamJobClusterMap(appName);
            return streamJobClusterMap.getStreamJobClusterMap();
        }
        logger.info("Failed to lookup stream to job cluster mapping for app {}", (Object)appName);
        return Collections.emptyMap();
    }

    @Override
    public String getJobCluster(String app, String stream) {
        String appName = this.configuration.appName();
        Optional<AppJobClustersMap> jobClusterMappingsO = this.getJobClusterMappings(appName);
        if (jobClusterMappingsO.isPresent()) {
            AppJobClustersMap appJobClustersMap = jobClusterMappingsO.get();
            StreamJobClusterMap streamJobClusterMap = appJobClustersMap.getStreamJobClusterMap(appName);
            return streamJobClusterMap.getJobCluster(stream);
        }
        logger.info("Failed to lookup job cluster for app {} stream {}", (Object)appName, (Object)stream);
        return JOB_CLUSTER_LOOKUP_FAILED;
    }

    private boolean shouldRefreshJobClusterMapping(String appName) {
        this.lastFetchTimeMs.putIfAbsent(appName, new AtomicLong(0L));
        long lastFetchMs = ((AtomicLong)this.lastFetchTimeMs.get(appName)).get();
        return System.currentTimeMillis() - lastFetchMs > (long)(this.configuration.jobClusterMappingRefreshIntervalSec() * 1000);
    }

    void refreshJobClusterMapping(String app) {
        CompletableFuture<AppJobClustersMap> jobClusterMappingF = this.mantisApiClient.getJobClusterMapping(Optional.ofNullable(app));
        AppJobClustersMap cachedMapping = (AppJobClustersMap)this.appJobClusterMapping.get(app);
        if (cachedMapping != null) {
            jobClusterMappingF.whenCompleteAsync((mapping, t) -> {
                if (mapping != null) {
                    long recvTimestamp = mapping.getTimestamp();
                    if (recvTimestamp >= cachedMapping.getTimestamp()) {
                        this.appJobClusterMapping.put(app, (AppJobClustersMap)mapping);
                        this.jobClusterMappingRefreshSuccess.increment();
                    } else {
                        logger.info("ignoring job cluster mapping refresh with older timestamp {} than cached {}", (Object)recvTimestamp, (Object)cachedMapping.getTimestamp());
                        this.jobClusterMappingRefreshFailed.increment();
                    }
                } else {
                    logger.info("failed to refresh job cluster mapping info, will serve old job cluster mapping");
                    this.jobClusterMappingRefreshFailed.increment();
                }
            });
        } else {
            try {
                AppJobClustersMap appJobClustersMap = jobClusterMappingF.get(1L, TimeUnit.SECONDS);
                this.appJobClusterMapping.put(app, appJobClustersMap);
                this.jobClusterMappingRefreshSuccess.increment();
            }
            catch (Exception e2) {
                logger.warn("exception getting job cluster mapping {}", (Object)app, (Object)e2);
                this.jobClusterMappingRefreshFailed.increment();
            }
        }
    }

    private String appWithFallback(String app) {
        return app == null ? "__default__" : app;
    }

    @Override
    public Optional<AppJobClustersMap> getJobClusterMappings(String app) {
        String appName = this.appWithFallback(app);
        if (this.shouldRefreshJobClusterMapping(appName)) {
            this.refreshJobClusterMapping(appName);
            ((AtomicLong)this.lastFetchTimeMs.get(appName)).set(System.currentTimeMillis());
        }
        return Optional.ofNullable(this.appJobClusterMapping.get(appName));
    }
}

