/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.internal.mql;

import io.mantisrx.mql.jvm.core.Query;
import io.mantisrx.mql.shaded.clojure.java.api.Clojure;
import io.mantisrx.mql.shaded.clojure.lang.IFn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQL {
    private static final Logger LOG = LoggerFactory.getLogger(MQL.class);
    private static IFn require = Clojure.var("io.mantisrx.mql.shaded.clojure.core", "require");
    private static IFn cljMakeQuery = Clojure.var("io.mantisrx.mql.jvm.interfaces.server", "make-query");
    private static IFn cljSuperset = Clojure.var("io.mantisrx.mql.jvm.interfaces.core", "queries->superset-projection");

    public static void init() {
        LOG.info("Initializing MQL Runtime.");
    }

    public static Query query(String subscriptionId, String query2) {
        return (Query)cljMakeQuery.invoke(subscriptionId, query2.trim());
    }

    public static Function<Map<String, Object>, Map<String, Object>> makeSupersetProjector(HashSet<Query> queries) {
        ArrayList<String> qs = new ArrayList<String>(queries.size());
        for (Query query2 : queries) {
            qs.add(query2.getRawQuery());
        }
        IFn ssProjector = (IFn)cljSuperset.invoke(new ArrayList(qs));
        return datum -> (Map)ssProjector.invoke(datum);
    }

    public static String preprocess(String criterion) {
        return criterion.toLowerCase().equals("true") ? "select * where true" : (criterion.toLowerCase().equals("false") ? "select * where false" : criterion);
    }

    public static boolean isContradictionQuery(String query2) {
        return query2.equals("false") || query2.equals("select * where false") || query2.equals("select * from stream where false");
    }

    static {
        require.invoke(Clojure.read("io.mantisrx.mql.jvm.interfaces.server"));
        require.invoke(Clojure.read("io.mantisrx.mql.jvm.interfaces.core"));
    }
}

