/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class BooleanMethodPropertyWriter
extends OptimizedBeanPropertyWriter<BooleanMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final boolean _suppressableSet;
    private final boolean _suppressableBoolean;

    public BooleanMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index2, JsonSerializer<Object> ser) {
        super(src, acc, index2, ser);
        if (this._suppressableValue instanceof Boolean) {
            this._suppressableBoolean = (Boolean)this._suppressableValue;
            this._suppressableSet = true;
        } else {
            this._suppressableBoolean = false;
            this._suppressableSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new BooleanMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public BooleanMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new BooleanMethodPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean2, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.booleanGetter(bean2, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            gen.writeFieldName(this._fastName);
            gen.writeBoolean(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean2, JsonGenerator gen, SerializerProvider prov) throws Exception {
        boolean value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean2, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.booleanGetter(bean2, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean2, gen, prov, t, true);
            return;
        }
        if (!this._suppressableSet || this._suppressableBoolean != value) {
            gen.writeBoolean(value);
        } else {
            this.serializeAsPlaceholder(bean2, gen, prov);
        }
    }
}

