/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec.memcache.binary;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.Unpooled;
import io.mantisrx.shaded.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import io.mantisrx.shaded.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;

public class DefaultFullBinaryMemcacheRequest
extends DefaultBinaryMemcacheRequest
implements FullBinaryMemcacheRequest {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheRequest(ByteBuf key2, ByteBuf extras) {
        this(key2, extras, Unpooled.buffer(0));
    }

    public DefaultFullBinaryMemcacheRequest(ByteBuf key2, ByteBuf extras, ByteBuf content) {
        super(key2, extras);
        if (content == null) {
            throw new NullPointerException("Supplied content is null.");
        }
        this.content = content;
        this.setTotalBodyLength(this.keyLength() + this.extrasLength() + content.readableBytes());
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public FullBinaryMemcacheRequest retain() {
        super.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest touch() {
        super.touch();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest touch(Object hint) {
        super.touch(hint);
        this.content.touch(hint);
        return this;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.content.release();
    }

    @Override
    public FullBinaryMemcacheRequest copy() {
        ByteBuf extras;
        ByteBuf key2 = this.key();
        if (key2 != null) {
            key2 = key2.copy();
        }
        if ((extras = this.extras()) != null) {
            extras = extras.copy();
        }
        return new DefaultFullBinaryMemcacheRequest(key2, extras, this.content().copy());
    }

    @Override
    public FullBinaryMemcacheRequest duplicate() {
        ByteBuf extras;
        ByteBuf key2 = this.key();
        if (key2 != null) {
            key2 = key2.duplicate();
        }
        if ((extras = this.extras()) != null) {
            extras = extras.duplicate();
        }
        return new DefaultFullBinaryMemcacheRequest(key2, extras, this.content().duplicate());
    }

    @Override
    public FullBinaryMemcacheRequest retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullBinaryMemcacheRequest replace(ByteBuf content) {
        ByteBuf extras;
        ByteBuf key2 = this.key();
        if (key2 != null) {
            key2 = key2.retainedDuplicate();
        }
        if ((extras = this.extras()) != null) {
            extras = extras.retainedDuplicate();
        }
        return new DefaultFullBinaryMemcacheRequest(key2, extras, content);
    }
}

