/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.ssl;

import io.mantisrx.shaded.io.netty.buffer.ByteBufAllocator;
import io.mantisrx.shaded.io.netty.handler.ssl.OpenSslKeyMaterial;
import io.mantisrx.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.X509KeyManager;

final class OpenSslCachingKeyMaterialProvider
extends OpenSslKeyMaterialProvider {
    private final ConcurrentMap<String, OpenSslKeyMaterial> cache = new ConcurrentHashMap<String, OpenSslKeyMaterial>();

    OpenSslCachingKeyMaterialProvider(X509KeyManager keyManager, String password) {
        super(keyManager, password);
    }

    @Override
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias2) throws Exception {
        OpenSslKeyMaterial material = (OpenSslKeyMaterial)this.cache.get(alias2);
        if (material == null) {
            material = super.chooseKeyMaterial(allocator, alias2);
            if (material == null) {
                return null;
            }
            OpenSslKeyMaterial old = this.cache.putIfAbsent(alias2, material);
            if (old != null) {
                material.release();
                material = old;
            }
        }
        return material.retain();
    }

    @Override
    void destroy() {
        do {
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                ((OpenSslKeyMaterial)iterator.next()).release();
                iterator.remove();
            }
        } while (!this.cache.isEmpty());
    }
}

