/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.util.collection;

import io.mantisrx.shaded.io.netty.util.collection.LongObjectMap;
import io.mantisrx.shaded.io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongObjectHashMap<V>
implements LongObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private long[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Long> keySet = new KeySet();
    private final Set<Map.Entry<Long, V>> entrySet = new EntrySet();
    private final Iterable<LongObjectMap.PrimitiveEntry<V>> entries = new Iterable<LongObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<LongObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public LongObjectHashMap() {
        this(8, 0.5f);
    }

    public LongObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public LongObjectHashMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = loadFactor;
        int capacity = MathUtil.safeFindNextPositivePowerOfTwo(initialCapacity);
        this.mask = capacity - 1;
        this.keys = new long[capacity];
        Object[] temp = new Object[capacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(capacity);
    }

    private static <T> T toExternal(T value) {
        assert (value != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return value == NULL_VALUE ? null : (T)value;
    }

    private static <T> T toInternal(T value) {
        return (T)(value == null ? NULL_VALUE : value);
    }

    @Override
    public V get(long key2) {
        int index2 = this.indexOf(key2);
        return index2 == -1 ? null : (V)LongObjectHashMap.toExternal(this.values[index2]);
    }

    @Override
    public V put(long key2, V value) {
        int startIndex;
        int index2 = startIndex = this.hashIndex(key2);
        do {
            if (this.values[index2] == null) {
                this.keys[index2] = key2;
                this.values[index2] = LongObjectHashMap.toInternal(value);
                this.growSize();
                return null;
            }
            if (this.keys[index2] != key2) continue;
            V previousValue = this.values[index2];
            this.values[index2] = LongObjectHashMap.toInternal(value);
            return LongObjectHashMap.toExternal(previousValue);
        } while ((index2 = this.probeNext(index2)) != startIndex);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> sourceMap) {
        if (sourceMap instanceof LongObjectHashMap) {
            LongObjectHashMap source2 = (LongObjectHashMap)sourceMap;
            for (int i = 0; i < source2.values.length; ++i) {
                V sourceValue = source2.values[i];
                if (sourceValue == null) continue;
                this.put(source2.keys[i], sourceValue);
            }
            return;
        }
        for (Map.Entry<Long, V> entry : sourceMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(long key2) {
        int index2 = this.indexOf(key2);
        if (index2 == -1) {
            return null;
        }
        V prev2 = this.values[index2];
        this.removeAt(index2);
        return LongObjectHashMap.toExternal(prev2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(long key2) {
        return this.indexOf(key2) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Object v1 = LongObjectHashMap.toInternal(value);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(v1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<LongObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return LongObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int hash2 = this.size;
        for (long key2 : this.keys) {
            hash2 ^= LongObjectHashMap.hashCode(key2);
        }
        return hash2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongObjectMap)) {
            return false;
        }
        LongObjectMap other = (LongObjectMap)obj;
        if (this.size != other.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V value = this.values[i];
            if (value == null) continue;
            long key2 = this.keys[i];
            Object otherValue = other.get(key2);
            if (!(value == NULL_VALUE ? otherValue != null : !value.equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.containsKey(this.objectToKey(key2));
    }

    @Override
    public V get(Object key2) {
        return this.get(this.objectToKey(key2));
    }

    @Override
    public V put(Long key2, V value) {
        return this.put(this.objectToKey(key2), value);
    }

    @Override
    public V remove(Object key2) {
        return this.remove(this.objectToKey(key2));
    }

    @Override
    public Set<Long> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.entrySet;
    }

    private long objectToKey(Object key2) {
        return (Long)key2;
    }

    private int indexOf(long key2) {
        int startIndex;
        int index2 = startIndex = this.hashIndex(key2);
        do {
            if (this.values[index2] == null) {
                return -1;
            }
            if (key2 != this.keys[index2]) continue;
            return index2;
        } while ((index2 = this.probeNext(index2)) != startIndex);
        return -1;
    }

    private int hashIndex(long key2) {
        return LongObjectHashMap.hashCode(key2) & this.mask;
    }

    private static int hashCode(long key2) {
        return (int)(key2 ^ key2 >>> 32);
    }

    private int probeNext(int index2) {
        return index2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int index2) {
        --this.size;
        this.keys[index2] = 0L;
        this.values[index2] = null;
        int nextFree = index2;
        int i = this.probeNext(index2);
        V value = this.values[i];
        while (value != null) {
            long key2 = this.keys[i];
            int bucket = this.hashIndex(key2);
            if (i < bucket && (bucket <= nextFree || nextFree <= i) || bucket <= nextFree && nextFree <= i) {
                this.keys[nextFree] = key2;
                this.values[nextFree] = value;
                this.keys[i] = 0L;
                this.values[i] = null;
                nextFree = i;
            }
            i = this.probeNext(i);
            value = this.values[i];
        }
        return nextFree != index2;
    }

    private int calcMaxSize(int capacity) {
        int upperBound = capacity - 1;
        return Math.min(upperBound, (int)((float)capacity * this.loadFactor));
    }

    private void rehash(int newCapacity) {
        long[] oldKeys = this.keys;
        V[] oldVals = this.values;
        this.keys = new long[newCapacity];
        Object[] temp = new Object[newCapacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(newCapacity);
        this.mask = newCapacity - 1;
        block0: for (int i = 0; i < oldVals.length; ++i) {
            V oldVal = oldVals[i];
            if (oldVal == null) continue;
            long oldKey = oldKeys[i];
            int index2 = this.hashIndex(oldKey);
            while (true) {
                if (this.values[index2] == null) {
                    this.keys[index2] = oldKey;
                    this.values[index2] = oldVal;
                    continue block0;
                }
                index2 = this.probeNext(index2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(4 * this.size);
        sb.append('{');
        boolean first2 = true;
        for (int i = 0; i < this.values.length; ++i) {
            V value = this.values[i];
            if (value == null) continue;
            if (!first2) {
                sb.append(", ");
            }
            sb.append(this.keyToString(this.keys[i])).append('=').append((Object)(value == this ? "(this Map)" : LongObjectHashMap.toExternal(value)));
            first2 = false;
        }
        return sb.append('}').toString();
    }

    protected String keyToString(long key2) {
        return Long.toString(key2);
    }

    final class MapEntry
    implements Map.Entry<Long, V> {
        private final int entryIndex;

        MapEntry(int entryIndex) {
            this.entryIndex = entryIndex;
        }

        @Override
        public Long getKey() {
            this.verifyExists();
            return LongObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V getValue() {
            this.verifyExists();
            return LongObjectHashMap.toExternal(LongObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public V setValue(V value) {
            this.verifyExists();
            Object prevValue = LongObjectHashMap.toExternal(LongObjectHashMap.this.values[this.entryIndex]);
            ((LongObjectHashMap)LongObjectHashMap.this).values[this.entryIndex] = LongObjectHashMap.toInternal(value);
            return prevValue;
        }

        private void verifyExists() {
            if (LongObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Long, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<Long, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements Iterator<LongObjectMap.PrimitiveEntry<V>>,
    LongObjectMap.PrimitiveEntry<V> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != LongObjectHashMap.this.values.length && LongObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != LongObjectHashMap.this.values.length;
        }

        @Override
        public LongObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (LongObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public long key() {
            return LongObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V value() {
            return LongObjectHashMap.toExternal(LongObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public void setValue(V value) {
            ((LongObjectHashMap)LongObjectHashMap.this).values[this.entryIndex] = LongObjectHashMap.toInternal(value);
        }
    }

    private final class KeySet
    extends AbstractSet<Long> {
        private KeySet() {
        }

        @Override
        public int size() {
            return LongObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return LongObjectHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return LongObjectHashMap.this.remove(o) != null;
        }

        @Override
        public boolean retainAll(Collection<?> retainedKeys) {
            boolean changed = false;
            Iterator iter = LongObjectHashMap.this.entries().iterator();
            while (iter.hasNext()) {
                LongObjectMap.PrimitiveEntry entry = iter.next();
                if (retainedKeys.contains(entry.key())) continue;
                changed = true;
                iter.remove();
            }
            return changed;
        }

        @Override
        public void clear() {
            LongObjectHashMap.this.clear();
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private final Iterator<Map.Entry<Long, V>> iter;
                {
                    this.iter = LongObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Long next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public int size() {
            return LongObjectHashMap.this.size();
        }
    }
}

