/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.MaplikeDeserializer;
import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.collection.SortedMap;
import io.vavr.collection.TreeMap;
import java.io.IOException;
import java.util.ArrayList;

class MapDeserializer
extends MaplikeDeserializer<Map<?, ?>> {
    private static final long serialVersionUID = 1L;

    MapDeserializer(JavaType valueType) {
        super(valueType);
    }

    @Override
    public Map<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList result = new ArrayList();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name2 = p.getCurrentName();
            Object key2 = this.keyDeserializer.deserializeKey(name2, ctxt);
            p.nextToken();
            result.add(Tuple.of(key2, this.valueDeserializer.deserialize(p, ctxt)));
        }
        if (SortedMap.class.isAssignableFrom(this.handledType())) {
            return TreeMap.ofEntries(this.keyComparator, result);
        }
        if (LinkedHashMap.class.isAssignableFrom(this.handledType())) {
            return LinkedHashMap.ofEntries(result);
        }
        return HashMap.ofEntries(result);
    }
}

