/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.cache;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.ChildData;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import java.util.Objects;

class PathChildrenCacheListenerWrapper
implements CuratorCacheListener {
    private final PathChildrenCacheListener listener;
    private final CuratorFramework client;
    private final String rootPath;

    PathChildrenCacheListenerWrapper(String rootPath, CuratorFramework client, PathChildrenCacheListener listener) {
        Objects.requireNonNull(rootPath, "rootPath cannot be null");
        this.rootPath = rootPath;
        this.listener = listener;
        this.client = client;
    }

    @Override
    public void event(CuratorCacheListener.Type type2, ChildData oldData, ChildData data2) {
        switch (type2) {
            case NODE_CREATED: {
                if (this.rootPath.equals(data2.getPath())) {
                    return;
                }
                this.sendEvent(data2, PathChildrenCacheEvent.Type.CHILD_ADDED);
                break;
            }
            case NODE_CHANGED: {
                if (this.rootPath.equals(data2.getPath())) {
                    return;
                }
                this.sendEvent(data2, PathChildrenCacheEvent.Type.CHILD_UPDATED);
                break;
            }
            case NODE_DELETED: {
                if (this.rootPath.equals(oldData.getPath())) {
                    return;
                }
                this.sendEvent(oldData, PathChildrenCacheEvent.Type.CHILD_REMOVED);
            }
        }
    }

    @Override
    public void initialized() {
        this.sendEvent(null, PathChildrenCacheEvent.Type.INITIALIZED);
    }

    private void sendEvent(ChildData node2, PathChildrenCacheEvent.Type type2) {
        PathChildrenCacheEvent event = new PathChildrenCacheEvent(type2, node2);
        try {
            this.listener.childEvent(this.client, event);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

