/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.cache;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.ChildData;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.TreeCacheListener;

class TreeCacheListenerWrapper
implements CuratorCacheListener {
    private final CuratorFramework client;
    private final TreeCacheListener listener;

    TreeCacheListenerWrapper(CuratorFramework client, TreeCacheListener listener) {
        this.client = client;
        this.listener = listener;
    }

    @Override
    public void event(CuratorCacheListener.Type type2, ChildData oldData, ChildData data2) {
        switch (type2) {
            case NODE_CREATED: {
                this.sendEvent(data2, null, TreeCacheEvent.Type.NODE_ADDED);
                break;
            }
            case NODE_CHANGED: {
                this.sendEvent(data2, oldData, TreeCacheEvent.Type.NODE_UPDATED);
                break;
            }
            case NODE_DELETED: {
                this.sendEvent(oldData, null, TreeCacheEvent.Type.NODE_REMOVED);
            }
        }
    }

    @Override
    public void initialized() {
        this.sendEvent(null, null, TreeCacheEvent.Type.INITIALIZED);
    }

    private void sendEvent(ChildData node2, ChildData oldNode, TreeCacheEvent.Type type2) {
        TreeCacheEvent event = new TreeCacheEvent(type2, node2, oldNode);
        try {
            this.listener.childEvent(this.client, event);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

