/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;

@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key2, Object value) {
        if (key2 == null) {
            throw new NullPointerException("null key in entry: null=" + value);
        }
        if (value == null) {
            throw new NullPointerException("null value in entry: " + key2 + "=null");
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value, String name2) {
        if (value < 0) {
            throw new IllegalArgumentException(name2 + " cannot be negative but was: " + value);
        }
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long value, String name2) {
        if (value < 0L) {
            throw new IllegalArgumentException(name2 + " cannot be negative but was: " + value);
        }
        return value;
    }

    static void checkPositive(int value, String name2) {
        if (value <= 0) {
            throw new IllegalArgumentException(name2 + " must be positive but was: " + value);
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

