/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper;

import io.mantisrx.shaded.org.apache.jute.InputArchive;
import io.mantisrx.shaded.org.apache.jute.OutputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.OpResult;
import io.mantisrx.shaded.org.apache.zookeeper.proto.Create2Response;
import io.mantisrx.shaded.org.apache.zookeeper.proto.CreateResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ErrorResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetChildrenResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetDataResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.MultiHeader;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetDataResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiResponse
implements Record,
Iterable<OpResult> {
    private List<OpResult> results = new ArrayList<OpResult>();

    public void add(OpResult x) {
        this.results.add(x);
    }

    @Override
    public Iterator<OpResult> iterator() {
        return this.results.iterator();
    }

    public int size() {
        return this.results.size();
    }

    @Override
    public void serialize(OutputArchive archive, String tag) throws IOException {
        archive.startRecord(this, tag);
        block9: for (OpResult result : this.results) {
            int err = result.getType() == -1 ? ((OpResult.ErrorResult)result).getErr() : 0;
            new MultiHeader(result.getType(), false, err).serialize(archive, tag);
            switch (result.getType()) {
                case 1: {
                    new CreateResponse(((OpResult.CreateResult)result).getPath()).serialize(archive, tag);
                    continue block9;
                }
                case 15: {
                    OpResult.CreateResult createResult = (OpResult.CreateResult)result;
                    new Create2Response(createResult.getPath(), createResult.getStat()).serialize(archive, tag);
                    continue block9;
                }
                case 2: 
                case 13: {
                    continue block9;
                }
                case 5: {
                    new SetDataResponse(((OpResult.SetDataResult)result).getStat()).serialize(archive, tag);
                    continue block9;
                }
                case 8: {
                    new GetChildrenResponse(((OpResult.GetChildrenResult)result).getChildren()).serialize(archive, tag);
                    continue block9;
                }
                case 4: {
                    new GetDataResponse(((OpResult.GetDataResult)result).getData(), ((OpResult.GetDataResult)result).getStat()).serialize(archive, tag);
                    continue block9;
                }
                case -1: {
                    new ErrorResponse(((OpResult.ErrorResult)result).getErr()).serialize(archive, tag);
                    continue block9;
                }
            }
            throw new IOException("Invalid type " + result.getType() + " in MultiResponse");
        }
        new MultiHeader(-1, true, -1).serialize(archive, tag);
        archive.endRecord(this, tag);
    }

    @Override
    public void deserialize(InputArchive archive, String tag) throws IOException {
        this.results = new ArrayList<OpResult>();
        archive.startRecord(tag);
        MultiHeader h = new MultiHeader();
        h.deserialize(archive, tag);
        while (!h.getDone()) {
            switch (h.getType()) {
                case 1: {
                    CreateResponse cr = new CreateResponse();
                    cr.deserialize(archive, tag);
                    this.results.add(new OpResult.CreateResult(cr.getPath()));
                    break;
                }
                case 15: {
                    Create2Response cr2 = new Create2Response();
                    cr2.deserialize(archive, tag);
                    this.results.add(new OpResult.CreateResult(cr2.getPath(), cr2.getStat()));
                    break;
                }
                case 2: {
                    this.results.add(new OpResult.DeleteResult());
                    break;
                }
                case 5: {
                    SetDataResponse sdr = new SetDataResponse();
                    sdr.deserialize(archive, tag);
                    this.results.add(new OpResult.SetDataResult(sdr.getStat()));
                    break;
                }
                case 13: {
                    this.results.add(new OpResult.CheckResult());
                    break;
                }
                case 8: {
                    GetChildrenResponse gcr = new GetChildrenResponse();
                    gcr.deserialize(archive, tag);
                    this.results.add(new OpResult.GetChildrenResult(gcr.getChildren()));
                    break;
                }
                case 4: {
                    GetDataResponse gdr = new GetDataResponse();
                    gdr.deserialize(archive, tag);
                    this.results.add(new OpResult.GetDataResult(gdr.getData(), gdr.getStat()));
                    break;
                }
                case -1: {
                    ErrorResponse er = new ErrorResponse();
                    er.deserialize(archive, tag);
                    this.results.add(new OpResult.ErrorResult(er.getErr()));
                    break;
                }
                default: {
                    throw new IOException("Invalid type " + h.getType() + " in MultiResponse");
                }
            }
            h.deserialize(archive, tag);
        }
        archive.endRecord(tag);
    }

    public List<OpResult> getResultList() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiResponse)) {
            return false;
        }
        MultiResponse other = (MultiResponse)o;
        if (this.results != null) {
            Iterator<OpResult> i = other.results.iterator();
            for (OpResult result : this.results) {
                if (i.hasNext()) {
                    if (result.equals(i.next())) continue;
                    return false;
                }
                return false;
            }
            return !i.hasNext();
        }
        return other.results == null;
    }

    public int hashCode() {
        int hash2 = this.results.size();
        for (OpResult result : this.results) {
            hash2 = hash2 * 35 + result.hashCode();
        }
        return hash2;
    }
}

