/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.cli;

import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.ZKUtil;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliCommand;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliParseException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedCommandException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedPathException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.StatPrinter;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class LsCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public LsCommand() {
        super("ls", "[-s] [-w] [-R] path");
    }

    private void printHelp() {
        HelpFormatter formatter2 = new HelpFormatter();
        formatter2.printHelp("ls [options] path", options);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser2 = new PosixParser();
        try {
            this.cl = parser2.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.cl.hasOption("?")) {
            this.printHelp();
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws CliParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'ls path [watch]' has been deprecated. Please use 'ls [-w] path' instead.");
            PosixParser parser2 = new PosixParser();
            try {
                this.cl = parser2.parse(options, cmdArgs);
            }
            catch (ParseException ex) {
                throw new CliParseException(ex);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        if (this.args.length < 2) {
            throw new MalformedCommandException(this.getUsageStr());
        }
        String path2 = this.args[1];
        boolean watch = this.cl.hasOption("w");
        boolean withStat = this.cl.hasOption("s");
        boolean recursive = this.cl.hasOption("R");
        try {
            if (recursive) {
                ZKUtil.visitSubTreeDFS(this.zk, path2, watch, new AsyncCallback.StringCallback(){

                    @Override
                    public void processResult(int rc, String path2, Object ctx, String name2) {
                        LsCommand.this.out.println(path2);
                    }
                });
            } else {
                Stat stat = withStat ? new Stat() : null;
                List<String> children2 = this.zk.getChildren(path2, watch, stat);
                this.printChildren(children2, stat);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return watch;
    }

    private void printChildren(List<String> children2, Stat stat) {
        Collections.sort(children2);
        this.out.append("[");
        boolean first2 = true;
        for (String child : children2) {
            if (!first2) {
                this.out.append(", ");
            } else {
                first2 = false;
            }
            this.out.append(child);
        }
        this.out.append("]\n");
        if (stat != null) {
            new StatPrinter(this.out).print(stat);
        }
    }

    static {
        options.addOption("?", false, "help");
        options.addOption("s", false, "stat");
        options.addOption("w", false, "watch");
        options.addOption("R", false, "recurse");
    }
}

