/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.cli;

import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.StatsTrack;
import io.mantisrx.shaded.org.apache.zookeeper.ZKUtil;
import io.mantisrx.shaded.org.apache.zookeeper.ZooDefs;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeper;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliCommand;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliParseException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedCommandException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedPathException;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetQuotaCommand
extends CliCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SetQuotaCommand.class);
    private Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetQuotaCommand() {
        super("setquota", "-n|-b val path");
        OptionGroup og1 = new OptionGroup();
        og1.addOption(new Option("b", true, "bytes quota"));
        og1.addOption(new Option("n", true, "num quota"));
        og1.setRequired(true);
        this.options.addOptionGroup(og1);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser2 = new PosixParser();
        try {
            this.cl = parser2.parse(this.options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path2 = this.args[1];
        if (path2.startsWith("/zookeeper/quota")) {
            this.err.println("cannot set a quota under the path: /zookeeper/quota");
            return false;
        }
        if (this.cl.hasOption("b")) {
            long bytes2 = Long.parseLong(this.cl.getOptionValue("b"));
            try {
                SetQuotaCommand.createQuota(this.zk, path2, bytes2, -1);
            }
            catch (KeeperException | IllegalArgumentException | InterruptedException ex) {
                throw new CliWrapperException(ex);
            }
        } else if (this.cl.hasOption("n")) {
            int numNodes = Integer.parseInt(this.cl.getOptionValue("n"));
            try {
                SetQuotaCommand.createQuota(this.zk, path2, -1L, numNodes);
            }
            catch (KeeperException | IllegalArgumentException | InterruptedException ex) {
                throw new CliWrapperException(ex);
            }
        } else {
            throw new MalformedCommandException(this.getUsageStr());
        }
        return false;
    }

    public static boolean createQuota(ZooKeeper zk, String path2, long bytes2, int numNodes) throws KeeperException, InterruptedException, IllegalArgumentException, MalformedPathException {
        Stat initStat;
        try {
            initStat = zk.exists(path2, false);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        if (initStat == null) {
            throw new IllegalArgumentException(path2 + " does not exist.");
        }
        String quotaPath = "/zookeeper/quota";
        SetQuotaCommand.checkIfChildQuota(zk, path2);
        SetQuotaCommand.checkIfParentQuota(zk, path2);
        if (zk.exists(quotaPath, false) == null) {
            try {
                zk.create("/zookeeper", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.create("/zookeeper/quota", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String[] splits = path2.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append(quotaPath);
        for (int i = 1; i < splits.length; ++i) {
            sb.append("/").append(splits[i]);
            quotaPath = sb.toString();
            try {
                zk.create(quotaPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String statPath = quotaPath + "/" + "zookeeper_stats";
        quotaPath = quotaPath + "/" + "zookeeper_limits";
        StatsTrack strack = new StatsTrack(null);
        strack.setBytes(bytes2);
        strack.setCount(numNodes);
        try {
            zk.create(quotaPath, strack.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            StatsTrack stats = new StatsTrack(null);
            stats.setBytes(0L);
            stats.setCount(0);
            zk.create(statPath, stats.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ne) {
            byte[] data2 = zk.getData(quotaPath, false, new Stat());
            StatsTrack strackC = new StatsTrack(new String(data2));
            if (bytes2 != -1L) {
                strackC.setBytes(bytes2);
            }
            if (numNodes != -1) {
                strackC.setCount(numNodes);
            }
            zk.setData(quotaPath, strackC.toString().getBytes(), -1);
        }
        return true;
    }

    private static void checkIfChildQuota(final ZooKeeper zk, final String path2) throws KeeperException, InterruptedException {
        String realPath = "/zookeeper/quota" + path2;
        try {
            ZKUtil.visitSubTreeDFS(zk, realPath, false, new AsyncCallback.StringCallback(){

                @Override
                public void processResult(int rc, String quotaPath, Object ctx, String name2) {
                    List<Object> children2 = new ArrayList();
                    try {
                        children2 = zk.getChildren(quotaPath, false);
                    }
                    catch (KeeperException.NoNodeException ne) {
                        LOG.debug("child removed during quota check", ne);
                        return;
                    }
                    catch (KeeperException | InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    if (children2.size() == 0) {
                        return;
                    }
                    for (String string2 : children2) {
                        if (quotaPath.equals("/zookeeper/quota" + path2) || !"zookeeper_limits".equals(string2)) continue;
                        throw new IllegalArgumentException(path2 + " has a child " + quotaPath.substring("/zookeeper/quota".length()) + " which has a quota");
                    }
                }
            });
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    private static void checkIfParentQuota(ZooKeeper zk, String path2) throws InterruptedException, KeeperException {
        String[] splits = path2.split("/");
        String quotaPath = "/zookeeper/quota";
        for (String str2 : splits) {
            if (str2.length() == 0) continue;
            quotaPath = quotaPath + "/" + str2;
            List<String> children2 = null;
            try {
                children2 = zk.getChildren(quotaPath, false);
            }
            catch (KeeperException.NoNodeException ne) {
                LOG.debug("child removed during quota check", ne);
                return;
            }
            if (children2.size() == 0) {
                return;
            }
            for (String child : children2) {
                if (quotaPath.equals("/zookeeper/quota" + path2) || !"zookeeper_limits".equals(child)) continue;
                throw new IllegalArgumentException(path2 + " has a parent " + quotaPath.substring("/zookeeper/quota".length()) + " which has a quota");
            }
        }
    }
}

