/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.common;

import io.mantisrx.shaded.org.apache.zookeeper.common.FileKeyStoreLoader;
import io.mantisrx.shaded.org.apache.zookeeper.common.JKSFileLoader;
import io.mantisrx.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import io.mantisrx.shaded.org.apache.zookeeper.common.PEMFileLoader;
import io.mantisrx.shaded.org.apache.zookeeper.common.PKCS12FileLoader;
import java.util.Objects;

public class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type2) {
        switch (Objects.requireNonNull(type2)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
            case PKCS12: {
                return new PKCS12FileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type2.name()));
    }
}

