/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.common;

public class PathUtils {
    public static void validatePath(String path2, boolean isSequential) throws IllegalArgumentException {
        PathUtils.validatePath(isSequential ? path2 + "1" : path2);
    }

    public static void validatePath(String path2) throws IllegalArgumentException {
        if (path2 == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (path2.length() == 0) {
            throw new IllegalArgumentException("Path length must be > 0");
        }
        if (path2.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with / character");
        }
        if (path2.length() == 1) {
            return;
        }
        if (path2.charAt(path2.length() - 1) == '/') {
            throw new IllegalArgumentException("Path must not end with / character");
        }
        String reason = null;
        int lastc = 47;
        char[] chars2 = path2.toCharArray();
        for (int i = 1; i < chars2.length; ++i) {
            char c = chars2[i];
            if (c == '\u0000') {
                reason = "null character not allowed @" + i;
                break;
            }
            if (c == '/' && lastc == 47) {
                reason = "empty node name specified @" + i;
                break;
            }
            if (c == '.' && lastc == 46) {
                if (chars2[i - 2] == '/' && (i + 1 == chars2.length || chars2[i + 1] == '/')) {
                    reason = "relative paths not allowed @" + i;
                    break;
                }
            } else if (c == '.') {
                if (chars2[i - 1] == '/' && (i + 1 == chars2.length || chars2[i + 1] == '/')) {
                    reason = "relative paths not allowed @" + i;
                    break;
                }
            } else if (c > '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\ud800' && c <= '\uf8ff' || c >= '\ufff0' && c <= '\uffff') {
                reason = "invalid character @" + i;
                break;
            }
            lastc = chars2[i];
        }
        if (reason != null) {
            throw new IllegalArgumentException("Invalid path string \"" + path2 + "\" caused by " + reason);
        }
    }

    public static String normalizeFileSystemPath(String path2) {
        String osname;
        if (path2 != null && (osname = System.getProperty("os.name")).toLowerCase().contains("windows")) {
            return path2.replace('\\', '/');
        }
        return path2;
    }
}

