/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.common.Time;
import org.slf4j.Logger;

public class RateLogger {
    private final long LOG_INTERVAL;
    private final Logger LOG;
    private String msg = null;
    private long timestamp;
    private int count = 0;
    private String value = null;

    public RateLogger(Logger log2) {
        this(log2, 100L);
    }

    public RateLogger(Logger log2, long interval) {
        this.LOG = log2;
        this.LOG_INTERVAL = interval;
    }

    public void flush() {
        if (this.msg != null && this.count > 0) {
            String log2 = "";
            if (this.count > 1) {
                log2 = "[" + this.count + " times] ";
            }
            log2 = log2 + "Message: " + this.msg;
            if (this.value != null) {
                log2 = log2 + " Last value:" + this.value;
            }
            this.LOG.warn(log2);
        }
        this.msg = null;
        this.value = null;
        this.count = 0;
    }

    public void rateLimitLog(String newMsg) {
        this.rateLimitLog(newMsg, null);
    }

    public void rateLimitLog(String newMsg, String value) {
        long now = Time.currentElapsedTime();
        if (newMsg.equals(this.msg)) {
            ++this.count;
            this.value = value;
            if (now - this.timestamp >= this.LOG_INTERVAL) {
                this.flush();
                this.msg = newMsg;
                this.timestamp = now;
                this.value = value;
            }
        } else {
            this.flush();
            this.msg = newMsg;
            this.value = value;
            this.timestamp = now;
            this.LOG.warn("Message:{} Value:{}", (Object)this.msg, (Object)value);
        }
    }
}

