/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.version.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mantisrx.shaded.org.apache.zookeeper.server.ExitCode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressFBWarnings(value={"DM_EXIT"})
public class VerGen {
    private static final String PACKAGE_NAME = "io.mantisrx.shaded.org.apache.zookeeper.version";
    private static final String VERSION_CLASS_NAME = "VersionInfoMain";
    private static final String VERSION_INTERFACE_NAME = "Info";

    static void printUsage() {
        System.out.print("Usage:\tjava  -cp <classpath> org.apache.zookeeper.version.util.VerGen maj.min.micro[-qualifier] rev buildDate outputDirectory");
        System.exit(ExitCode.UNEXPECTED_ERROR.getValue());
    }

    public static void generateFile(File outputDir, Version version, String rev, String buildDate) {
        Throwable throwable;
        FileWriter w;
        String path2 = PACKAGE_NAME.replaceAll("\\.", "/");
        File pkgdir = new File(outputDir, path2);
        if (!pkgdir.exists()) {
            boolean ret = pkgdir.mkdirs();
            if (!ret) {
                System.out.println("Cannnot create directory: " + path2);
                System.exit(ExitCode.UNEXPECTED_ERROR.getValue());
            }
        } else if (!pkgdir.isDirectory()) {
            System.out.println(path2 + " is not a directory.");
            System.exit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        try {
            w = new FileWriter(new File(pkgdir, "Info.java"));
            throwable = null;
            try {
                w.write("// Do not edit!\n// File generated by org.apache.zookeeper.version.util.VerGen.\n");
                w.write("/**\n");
                w.write("* Licensed to the Apache Software Foundation (ASF) under one\n");
                w.write("* or more contributor license agreements.  See the NOTICE file\n");
                w.write("* distributed with this work for additional information\n");
                w.write("* regarding copyright ownership.  The ASF licenses this file\n");
                w.write("* to you under the Apache License, Version 2.0 (the\n");
                w.write("* \"License\"); you may not use this file except in compliance\n");
                w.write("* with the License.  You may obtain a copy of the License at\n");
                w.write("*\n");
                w.write("*     http://www.apache.org/licenses/LICENSE-2.0\n");
                w.write("*\n");
                w.write("* Unless required by applicable law or agreed to in writing, software\n");
                w.write("* distributed under the License is distributed on an \"AS IS\" BASIS,\n");
                w.write("* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n");
                w.write("* See the License for the specific language governing permissions and\n");
                w.write("* limitations under the License.\n");
                w.write("*/\n");
                w.write("\n");
                w.write("package org.apache.zookeeper.version;\n\n");
                w.write("public interface Info {\n");
                w.write("    int MAJOR=" + version.maj + ";\n");
                w.write("    int MINOR=" + version.min + ";\n");
                w.write("    int MICRO=" + version.micro + ";\n");
                w.write("    String QUALIFIER=" + (version.qualifier == null ? "\"\"" : "\"" + version.qualifier + "\"") + ";\n");
                if (rev.equals("-1")) {
                    System.out.println("Unknown REVISION number, using " + rev);
                }
                w.write("    String REVISION_HASH=\"" + rev + "\";\n");
                w.write("    String BUILD_DATE=\"" + buildDate + "\";\n");
                w.write("}\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (w != null) {
                    if (throwable != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (IOException e2) {
            System.out.println("Unable to generate version.Info file: " + e2.getMessage());
            System.exit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        try {
            w = new FileWriter(new File(pkgdir, "VersionInfoMain.java"));
            throwable = null;
            try {
                w.write("// Do not edit!\n// File generated by org.apache.zookeeper.version.util.VerGen.\n");
                w.write("/**\n");
                w.write("* Licensed to the Apache Software Foundation (ASF) under one\n");
                w.write("* or more contributor license agreements.  See the NOTICE file\n");
                w.write("* distributed with this work for additional information\n");
                w.write("* regarding copyright ownership.  The ASF licenses this file\n");
                w.write("* to you under the Apache License, Version 2.0 (the\n");
                w.write("* \"License\"); you may not use this file except in compliance\n");
                w.write("* with the License.  You may obtain a copy of the License at\n");
                w.write("*\n");
                w.write("*     http://www.apache.org/licenses/LICENSE-2.0\n");
                w.write("*\n");
                w.write("* Unless required by applicable law or agreed to in writing, software\n");
                w.write("* distributed under the License is distributed on an \"AS IS\" BASIS,\n");
                w.write("* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n");
                w.write("* See the License for the specific language governing permissions and\n");
                w.write("* limitations under the License.\n");
                w.write("*/\n");
                w.write("\n");
                w.write("package org.apache.zookeeper.version;\n\n");
                w.write("public class VersionInfoMain implements org.apache.zookeeper.version.Info {\n");
                w.write("    public static void main(String[] args) {\n");
                w.write("        final String VER_STRING = MAJOR + \".\" + MINOR + \".\" + MICRO +");
                w.write("            (QUALIFIER == null ? \"\" : \"-\" + QUALIFIER)  + \" \" +");
                w.write("            BUILD_DATE;\n");
                w.write("        System.out.println(\"Apache ZooKeeper, version \" + VER_STRING);\n");
                w.write("    }\n");
                w.write("}\n");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (w != null) {
                    if (throwable != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (IOException e3) {
            System.out.println("Unable to generate version.VersionInfoMain file: " + e3.getMessage());
            System.exit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    public static Version parseVersionString(String input) {
        Version result = new Version();
        Pattern p = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)((\\.\\d+)*)(-(.+))?$");
        Matcher m = p.matcher(input);
        if (!m.matches()) {
            return null;
        }
        result.maj = Integer.parseInt(m.group(1));
        result.min = Integer.parseInt(m.group(2));
        result.micro = Integer.parseInt(m.group(3));
        result.qualifier = m.groupCount() == 7 ? m.group(7) : null;
        return result;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            VerGen.printUsage();
        }
        try {
            String rev;
            Version version = VerGen.parseVersionString(args[0]);
            if (version == null) {
                System.err.println("Invalid version number format, must be \"x.y.z(-.*)?\"");
                System.exit(ExitCode.UNEXPECTED_ERROR.getValue());
            }
            rev = (rev = args[1]) == null || rev.trim().isEmpty() ? "-1" : rev.trim();
            VerGen.generateFile(new File(args[3]), version, rev, args[2]);
        }
        catch (NumberFormatException e2) {
            System.err.println("All version-related parameters must be valid integers!");
            throw e2;
        }
    }

    public static class Version {
        public int maj;
        public int min;
        public int micro;
        public String qualifier;
    }
}

