/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket.nio;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelException;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFactory;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelSink;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.DatagramChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.InternetProtocolFamily;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.DefaultNioDatagramChannelConfig;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioDatagramChannelConfig;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.ProtocolFamilyConverter;
import io.mantisrx.shaded.org.jboss.netty.util.internal.DetectionUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.MembershipKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioDatagramChannel
extends AbstractNioChannel<java.nio.channels.DatagramChannel>
implements DatagramChannel {
    private final NioDatagramChannelConfig config;
    private Map<InetAddress, List<MembershipKey>> memberships;

    NioDatagramChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioDatagramWorker worker, InternetProtocolFamily family) {
        super(null, factory, pipeline, sink, worker, NioDatagramChannel.openNonBlockingChannel(family));
        this.config = new DefaultNioDatagramChannelConfig((java.nio.channels.DatagramChannel)this.channel);
        Channels.fireChannelOpen(this);
    }

    private static java.nio.channels.DatagramChannel openNonBlockingChannel(InternetProtocolFamily family) {
        try {
            java.nio.channels.DatagramChannel channel;
            if (DetectionUtil.javaVersion() < 7 || family == null) {
                channel = java.nio.channels.DatagramChannel.open();
            } else {
                switch (family) {
                    case IPv4: {
                        channel = java.nio.channels.DatagramChannel.open(ProtocolFamilyConverter.convert(family));
                        break;
                    }
                    case IPv6: {
                        channel = java.nio.channels.DatagramChannel.open(ProtocolFamilyConverter.convert(family));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            channel.configureBlocking(false);
            return channel;
        }
        catch (IOException e2) {
            throw new ChannelException("Failed to open a DatagramChannel.", e2);
        }
    }

    @Override
    public NioDatagramWorker getWorker() {
        return (NioDatagramWorker)super.getWorker();
    }

    @Override
    public boolean isBound() {
        return this.isOpen() && ((java.nio.channels.DatagramChannel)this.channel).socket().isBound();
    }

    @Override
    public boolean isConnected() {
        return ((java.nio.channels.DatagramChannel)this.channel).isConnected();
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    @Override
    public NioDatagramChannelConfig getConfig() {
        return this.config;
    }

    java.nio.channels.DatagramChannel getDatagramChannel() {
        return (java.nio.channels.DatagramChannel)this.channel;
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress) {
        try {
            return this.joinGroup(multicastAddress, NetworkInterface.getByInetAddress(this.getLocalAddress().getAddress()), null);
        }
        catch (SocketException e2) {
            return Channels.failedFuture(this, e2);
        }
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.joinGroup(multicastAddress.getAddress(), networkInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source2) {
        if (DetectionUtil.javaVersion() < 7) {
            throw new UnsupportedOperationException();
        }
        if (multicastAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        try {
            MembershipKey key2 = source2 == null ? ((java.nio.channels.DatagramChannel)this.channel).join(multicastAddress, networkInterface) : ((java.nio.channels.DatagramChannel)this.channel).join(multicastAddress, networkInterface, source2);
            NioDatagramChannel nioDatagramChannel = this;
            synchronized (nioDatagramChannel) {
                List<MembershipKey> keys2;
                if (this.memberships == null) {
                    this.memberships = new HashMap<InetAddress, List<MembershipKey>>();
                }
                if ((keys2 = this.memberships.get(multicastAddress)) == null) {
                    keys2 = new ArrayList<MembershipKey>();
                    this.memberships.put(multicastAddress, keys2);
                }
                keys2.add(key2);
            }
        }
        catch (Throwable e2) {
            return Channels.failedFuture(this, e2);
        }
        return Channels.succeededFuture(this);
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress) {
        try {
            return this.leaveGroup(multicastAddress, NetworkInterface.getByInetAddress(this.getLocalAddress().getAddress()), null);
        }
        catch (SocketException e2) {
            return Channels.failedFuture(this, e2);
        }
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(multicastAddress.getAddress(), networkInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source2) {
        if (DetectionUtil.javaVersion() < 7) {
            throw new UnsupportedOperationException();
        }
        if (multicastAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            List<MembershipKey> keys2;
            if (this.memberships != null && (keys2 = this.memberships.get(multicastAddress)) != null) {
                Iterator<MembershipKey> keyIt = keys2.iterator();
                while (keyIt.hasNext()) {
                    MembershipKey key2 = keyIt.next();
                    if (!networkInterface.equals(key2.networkInterface()) || (source2 != null || key2.sourceAddress() != null) && (source2 == null || !source2.equals(key2.sourceAddress()))) continue;
                    key2.drop();
                    keyIt.remove();
                }
                if (keys2.isEmpty()) {
                    this.memberships.remove(multicastAddress);
                }
            }
        }
        return Channels.succeededFuture(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        if (DetectionUtil.javaVersion() < 7) {
            throw new UnsupportedOperationException();
        }
        if (multicastAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (sourceToBlock == null) {
            throw new NullPointerException("sourceToBlock");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            if (this.memberships != null) {
                List<MembershipKey> keys2 = this.memberships.get(multicastAddress);
                for (MembershipKey key2 : keys2) {
                    if (!networkInterface.equals(key2.networkInterface())) continue;
                    try {
                        key2.block(sourceToBlock);
                    }
                    catch (IOException e2) {
                        return Channels.failedFuture(this, e2);
                    }
                }
            }
        }
        return Channels.succeededFuture(this);
    }

    public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        try {
            this.block(multicastAddress, NetworkInterface.getByInetAddress(this.getLocalAddress().getAddress()), sourceToBlock);
        }
        catch (SocketException e2) {
            return Channels.failedFuture(this, e2);
        }
        return Channels.succeededFuture(this);
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.DatagramChannel)this.channel).socket().getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.DatagramChannel)this.channel).socket().getRemoteSocketAddress();
    }

    @Override
    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return super.write(message, remoteAddress);
    }
}

