/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.ipfilter;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelState;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.handler.ipfilter.IpFilteringHandlerImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ChannelHandler.Sharable
public class OneIpFilterHandler
extends IpFilteringHandlerImpl {
    private final ConcurrentMap<InetAddress, Boolean> connectedSet = new ConcurrentHashMap<InetAddress, Boolean>();

    protected boolean accept(ChannelHandlerContext ctx, ChannelEvent e2, InetSocketAddress inetSocketAddress) throws Exception {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (this.connectedSet.containsKey(inetAddress)) {
            return false;
        }
        this.connectedSet.put(inetAddress, Boolean.TRUE);
        return true;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        ChannelStateEvent evt;
        super.handleUpstream(ctx, e2);
        if (e2 instanceof ChannelStateEvent && (evt = (ChannelStateEvent)e2).getState() == ChannelState.CONNECTED && evt.getValue() == null && this.isBlocked(ctx)) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)e2.getChannel().getRemoteAddress();
            this.connectedSet.remove(inetSocketAddress.getAddress());
        }
    }
}

