/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);

    public static int toInt(String str2) {
        return NumberUtils.toInt(str2, 0);
    }

    public static int toInt(String str2, int defaultValue) {
        if (str2 == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str2);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String str2) {
        return NumberUtils.toLong(str2, 0L);
    }

    public static long toLong(String str2, long defaultValue) {
        if (str2 == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str2);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(String str2) {
        return NumberUtils.toFloat(str2, 0.0f);
    }

    public static float toFloat(String str2, float defaultValue) {
        if (str2 == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str2);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(String str2) {
        return NumberUtils.toDouble(str2, 0.0);
    }

    public static double toDouble(String str2, double defaultValue) {
        if (str2 == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str2);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static byte toByte(String str2) {
        return NumberUtils.toByte(str2, (byte)0);
    }

    public static byte toByte(String str2, byte defaultValue) {
        if (str2 == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str2);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static short toShort(String str2) {
        return NumberUtils.toShort(str2, (short)0);
    }

    public static short toShort(String str2, short defaultValue) {
        if (str2 == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str2);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Number createNumber(String str2) throws NumberFormatException {
        String exp;
        String mant;
        String dec2;
        if (str2 == null) {
            return null;
        }
        if (StringUtils.isBlank(str2)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        String[] hex_prefixes = new String[]{"0x", "0X", "-0x", "-0X", "#", "-#"};
        int pfxLen = 0;
        for (String pfx : hex_prefixes) {
            if (!str2.startsWith(pfx)) continue;
            pfxLen += pfx.length();
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i = pfxLen; i < str2.length() && (firstSigDigit = str2.charAt(i)) == '0'; ++i) {
                ++pfxLen;
            }
            int hexDigits = str2.length() - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return NumberUtils.createBigInteger(str2);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return NumberUtils.createLong(str2);
            }
            return NumberUtils.createInteger(str2);
        }
        char lastChar = str2.charAt(str2.length() - 1);
        int decPos = str2.indexOf(46);
        int expPos = str2.indexOf(101) + str2.indexOf(69) + 1;
        int numDecimals = 0;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos || expPos > str2.length()) {
                    throw new NumberFormatException(str2 + " is not a valid number.");
                }
                dec2 = str2.substring(decPos + 1, expPos);
            } else {
                dec2 = str2.substring(decPos + 1);
            }
            mant = str2.substring(0, decPos);
            numDecimals = dec2.length();
        } else {
            if (expPos > -1) {
                if (expPos > str2.length()) {
                    throw new NumberFormatException(str2 + " is not a valid number.");
                }
                mant = str2.substring(0, expPos);
            } else {
                mant = str2;
            }
            dec2 = null;
        }
        if (!Character.isDigit(lastChar) && lastChar != '.') {
            exp = expPos > -1 && expPos < str2.length() - 1 ? str2.substring(expPos + 1, str2.length() - 1) : null;
            String numeric = str2.substring(0, str2.length() - 1);
            boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec2 == null && exp == null && (numeric.charAt(0) == '-' && NumberUtils.isDigits(numeric.substring(1)) || NumberUtils.isDigits(numeric))) {
                        try {
                            return NumberUtils.createLong(numeric);
                        }
                        catch (NumberFormatException nfe) {
                            return NumberUtils.createBigInteger(numeric);
                        }
                    }
                    throw new NumberFormatException(str2 + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = NumberUtils.createFloat(numeric);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return f;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = NumberUtils.createDouble(numeric);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            return d;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(numeric);
                    }
                    catch (NumberFormatException e2) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(str2 + " is not a valid number.");
        }
        exp = expPos > -1 && expPos < str2.length() - 1 ? str2.substring(expPos + 1, str2.length()) : null;
        if (dec2 == null && exp == null) {
            try {
                return NumberUtils.createInteger(str2);
            }
            catch (NumberFormatException nfe) {
                try {
                    return NumberUtils.createLong(str2);
                }
                catch (NumberFormatException nfe2) {
                    return NumberUtils.createBigInteger(str2);
                }
            }
        }
        boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
        try {
            Float f;
            if (numDecimals <= 7 && !(f = NumberUtils.createFloat(str2)).isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                return f;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            Double d;
            if (numDecimals <= 16 && !(d = NumberUtils.createDouble(str2)).isInfinite() && (d != 0.0 || allZeros)) {
                return d;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(str2);
    }

    private static boolean isAllZeros(String str2) {
        if (str2 == null) {
            return true;
        }
        for (int i = str2.length() - 1; i >= 0; --i) {
            if (str2.charAt(i) == '0') continue;
            return false;
        }
        return str2.length() > 0;
    }

    public static Float createFloat(String str2) {
        if (str2 == null) {
            return null;
        }
        return Float.valueOf(str2);
    }

    public static Double createDouble(String str2) {
        if (str2 == null) {
            return null;
        }
        return Double.valueOf(str2);
    }

    public static Integer createInteger(String str2) {
        if (str2 == null) {
            return null;
        }
        return Integer.decode(str2);
    }

    public static Long createLong(String str2) {
        if (str2 == null) {
            return null;
        }
        return Long.decode(str2);
    }

    public static BigInteger createBigInteger(String str2) {
        if (str2 == null) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str2.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str2.startsWith("0x", pos) || str2.startsWith("0x", pos)) {
            radix = 16;
            pos += 2;
        } else if (str2.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str2.startsWith("0", pos) && str2.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        BigInteger value = new BigInteger(str2.substring(pos), radix);
        return negate ? value.negate() : value;
    }

    public static BigDecimal createBigDecimal(String str2) {
        if (str2 == null) {
            return null;
        }
        if (StringUtils.isBlank(str2)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str2.trim().startsWith("--")) {
            throw new NumberFormatException(str2 + " is not a valid number.");
        }
        return new BigDecimal(str2);
    }

    public static long min(long[] array2) {
        NumberUtils.validateArray(array2);
        long min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min2) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static int min(int[] array2) {
        NumberUtils.validateArray(array2);
        int min2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (array2[j] >= min2) continue;
            min2 = array2[j];
        }
        return min2;
    }

    public static short min(short[] array2) {
        NumberUtils.validateArray(array2);
        short min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min2) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static byte min(byte[] array2) {
        NumberUtils.validateArray(array2);
        byte min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min2) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static double min(double[] array2) {
        NumberUtils.validateArray(array2);
        double min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (Double.isNaN(array2[i])) {
                return Double.NaN;
            }
            if (!(array2[i] < min2)) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static float min(float[] array2) {
        NumberUtils.validateArray(array2);
        float min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (Float.isNaN(array2[i])) {
                return Float.NaN;
            }
            if (!(array2[i] < min2)) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static long max(long[] array2) {
        NumberUtils.validateArray(array2);
        long max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (array2[j] <= max2) continue;
            max2 = array2[j];
        }
        return max2;
    }

    public static int max(int[] array2) {
        NumberUtils.validateArray(array2);
        int max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (array2[j] <= max2) continue;
            max2 = array2[j];
        }
        return max2;
    }

    public static short max(short[] array2) {
        NumberUtils.validateArray(array2);
        short max2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max2) continue;
            max2 = array2[i];
        }
        return max2;
    }

    public static byte max(byte[] array2) {
        NumberUtils.validateArray(array2);
        byte max2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max2) continue;
            max2 = array2[i];
        }
        return max2;
    }

    public static double max(double[] array2) {
        NumberUtils.validateArray(array2);
        double max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (Double.isNaN(array2[j])) {
                return Double.NaN;
            }
            if (!(array2[j] > max2)) continue;
            max2 = array2[j];
        }
        return max2;
    }

    public static float max(float[] array2) {
        NumberUtils.validateArray(array2);
        float max2 = array2[0];
        for (int j = 1; j < array2.length; ++j) {
            if (Float.isNaN(array2[j])) {
                return Float.NaN;
            }
            if (!(array2[j] > max2)) continue;
            max2 = array2[j];
        }
        return max2;
    }

    private static void validateArray(Object array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (Array.getLength(array2) == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
    }

    public static long min(long a, long b, long c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static int min(int a, int b, int c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static short min(short a, short b, short c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static byte min(byte a, byte b, byte c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static long max(long a, long b, long c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int max(int a, int b, int c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static short max(short a, short b, short c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static byte max(byte a, byte b, byte c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    public static boolean isDigits(String str2) {
        if (StringUtils.isEmpty(str2)) {
            return false;
        }
        for (int i = 0; i < str2.length(); ++i) {
            if (Character.isDigit(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str2) {
        int i;
        int start;
        if (StringUtils.isEmpty(str2)) {
            return false;
        }
        char[] chars2 = str2.toCharArray();
        int sz = chars2.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars2[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars2[start] == '0') {
            if (chars2[start + 1] == 'x' || chars2[start + 1] == 'X') {
                int i2 = start + 2;
                if (i2 == sz) {
                    return false;
                }
                while (i2 < chars2.length) {
                    if (!(chars2[i2] >= '0' && chars2[i2] <= '9' || chars2[i2] >= 'a' && chars2[i2] <= 'f' || chars2[i2] >= 'A' && chars2[i2] <= 'F')) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            if (Character.isDigit(chars2[start + 1])) {
                for (int i3 = start + 1; i3 < chars2.length; ++i3) {
                    if (chars2[i3] >= '0' && chars2[i3] <= '7') continue;
                    return false;
                }
                return true;
            }
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars2[i] >= '0' && chars2[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars2[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars2[i] == 'e' || chars2[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars2[i] == '+' || chars2[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars2.length) {
            if (chars2[i] >= '0' && chars2[i] <= '9') {
                return true;
            }
            if (chars2[i] == 'e' || chars2[i] == 'E') {
                return false;
            }
            if (chars2[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars2[i] != 'd' && chars2[i] != 'D' && chars2[i] != 'f' && chars2[i] != 'F')) {
                return foundDigit;
            }
            if (chars2[i] == 'l' || chars2[i] == 'L') {
                return foundDigit && !hasExp && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }
}

