/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.internal.subscriptions.SequentialSubscription;

public final class CompletableOnSubscribeConcatArray
implements Completable.OnSubscribe {
    final Completable[] sources;

    public CompletableOnSubscribeConcatArray(Completable[] sources) {
        this.sources = sources;
    }

    @Override
    public void call(CompletableSubscriber s) {
        ConcatInnerSubscriber inner = new ConcatInnerSubscriber(s, this.sources);
        s.onSubscribe(inner.sd);
        inner.next();
    }

    static final class ConcatInnerSubscriber
    extends AtomicInteger
    implements CompletableSubscriber {
        private static final long serialVersionUID = -7965400327305809232L;
        final CompletableSubscriber actual;
        final Completable[] sources;
        int index;
        final SequentialSubscription sd;

        public ConcatInnerSubscriber(CompletableSubscriber actual, Completable[] sources) {
            this.actual = actual;
            this.sources = sources;
            this.sd = new SequentialSubscription();
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.sd.replace(d);
        }

        @Override
        public void onError(Throwable e2) {
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            this.next();
        }

        void next() {
            if (this.sd.isUnsubscribed()) {
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
            Completable[] a = this.sources;
            do {
                int idx;
                if (this.sd.isUnsubscribed()) {
                    return;
                }
                ++this.index;
                if (idx == a.length) {
                    this.actual.onCompleted();
                    return;
                }
                a[idx].unsafeSubscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

