/*
 * Decompiled with CFR 0.152.
 */
package rx.singles;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.internal.operators.BlockingOperatorToFuture;
import rx.internal.util.BlockingUtils;

public final class BlockingSingle<T> {
    private final Single<? extends T> single;

    private BlockingSingle(Single<? extends T> single2) {
        this.single = single2;
    }

    public static <T> BlockingSingle<T> from(Single<? extends T> single2) {
        return new BlockingSingle<T>(single2);
    }

    public T value() {
        final AtomicReference returnItem = new AtomicReference();
        final AtomicReference returnException = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Subscription subscription2 = this.single.subscribe(new SingleSubscriber<T>(){

            @Override
            public void onSuccess(T value) {
                returnItem.set(value);
                latch.countDown();
            }

            @Override
            public void onError(Throwable error) {
                returnException.set(error);
                latch.countDown();
            }
        });
        BlockingUtils.awaitForComplete(latch, subscription2);
        Throwable throwable = (Throwable)returnException.get();
        if (throwable != null) {
            throw Exceptions.propagate(throwable);
        }
        return (T)returnItem.get();
    }

    public Future<T> toFuture() {
        return BlockingOperatorToFuture.toFuture(this.single.toObservable());
    }
}

