/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyContainer;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.PropertyListener;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyFactory
implements PropertyFactory,
ConfigListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPropertyFactory.class);
    private final Config config;
    private final ConcurrentMap<KeyAndType<?>, Property<?>> properties = new ConcurrentHashMap();
    private final AtomicInteger masterVersion = new AtomicInteger();
    private final List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

    public static DefaultPropertyFactory from(Config config) {
        return new DefaultPropertyFactory(config);
    }

    public DefaultPropertyFactory(Config config) {
        this.config = config;
        this.config.addListener(this);
    }

    @Override
    public PropertyContainer getProperty(final String propName) {
        return new PropertyContainer(){

            @Override
            public Property<String> asString(String defaultValue) {
                return DefaultPropertyFactory.this.get(propName, String.class).orElse(defaultValue);
            }

            @Override
            public Property<Integer> asInteger(Integer defaultValue) {
                return DefaultPropertyFactory.this.get(propName, Integer.class).orElse(defaultValue);
            }

            @Override
            public Property<Long> asLong(Long defaultValue) {
                return DefaultPropertyFactory.this.get(propName, Long.class).orElse(defaultValue);
            }

            @Override
            public Property<Double> asDouble(Double defaultValue) {
                return DefaultPropertyFactory.this.get(propName, Double.class).orElse(defaultValue);
            }

            @Override
            public Property<Float> asFloat(Float defaultValue) {
                return DefaultPropertyFactory.this.get(propName, Float.class).orElse(defaultValue);
            }

            @Override
            public Property<Short> asShort(Short defaultValue) {
                return DefaultPropertyFactory.this.get(propName, Short.class).orElse(defaultValue);
            }

            @Override
            public Property<Byte> asByte(Byte defaultValue) {
                return DefaultPropertyFactory.this.get(propName, Byte.class).orElse(defaultValue);
            }

            @Override
            public Property<Boolean> asBoolean(Boolean defaultValue) {
                return DefaultPropertyFactory.this.get(propName, Boolean.class).orElse(defaultValue);
            }

            @Override
            public Property<BigDecimal> asBigDecimal(BigDecimal defaultValue) {
                return DefaultPropertyFactory.this.get(propName, BigDecimal.class).orElse(defaultValue);
            }

            @Override
            public Property<BigInteger> asBigInteger(BigInteger defaultValue) {
                return DefaultPropertyFactory.this.get(propName, BigInteger.class).orElse(defaultValue);
            }

            @Override
            public <T> Property<T> asType(Class<T> type2, T defaultValue) {
                return DefaultPropertyFactory.this.get(propName, type2).orElse(defaultValue);
            }

            @Override
            public <T> Property<T> asType(Function<String, T> mapper, String defaultValue) {
                Object typedDefaultValue = mapper.apply(defaultValue);
                return DefaultPropertyFactory.this.getFromSupplier(propName, null, () -> {
                    String value = DefaultPropertyFactory.this.config.getString(propName, null);
                    if (value != null) {
                        try {
                            return mapper.apply(value);
                        }
                        catch (Exception e2) {
                            LOG.warn("Invalid value '{}' for property '{}'", (Object)propName, (Object)value);
                        }
                    }
                    return typedDefaultValue;
                });
            }
        };
    }

    @Override
    public void onConfigAdded(Config config) {
        this.invalidate();
    }

    @Override
    public void onConfigRemoved(Config config) {
        this.invalidate();
    }

    @Override
    public void onConfigUpdated(Config config) {
        this.invalidate();
    }

    @Override
    public void onError(Throwable error, Config config) {
    }

    public void invalidate() {
        this.masterVersion.incrementAndGet();
        this.listeners.forEach(Runnable::run);
    }

    protected Config getConfig() {
        return this.config;
    }

    @Override
    public <T> Property<T> get(String key2, Class<T> type2) {
        return this.getFromSupplier(key2, type2, () -> this.config.get(type2, key2, null));
    }

    @Override
    public <T> Property<T> get(String key2, Type type2) {
        return this.getFromSupplier(key2, type2, () -> this.config.get(type2, key2, null));
    }

    private <T> Property<T> getFromSupplier(String key2, Type type2, Supplier<T> supplier) {
        return this.getFromSupplier(new KeyAndType(key2, type2), supplier);
    }

    private <T> Property<T> getFromSupplier(KeyAndType<T> keyAndType, Supplier<T> supplier) {
        return this.properties.computeIfAbsent(keyAndType, ignore -> new PropertyImpl(keyAndType, supplier));
    }

    private static final class KeyAndType<T> {
        private final String key;
        private final Type type;

        public KeyAndType(String key2, Type type2) {
            this.key = key2;
            this.type = type2;
        }

        public <S> KeyAndType<S> discardType() {
            return new KeyAndType<T>(this.key, null);
        }

        public KeyAndType<T> withKey(String newKey) {
            return new KeyAndType<T>(newKey, this.type);
        }

        public boolean hasType() {
            return this.type != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyAndType other = (KeyAndType)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    private class PropertyImpl<T>
    implements Property<T> {
        private final KeyAndType<T> keyAndType;
        private final Supplier<T> supplier;
        private final AtomicStampedReference<T> cache = new AtomicStampedReference<Object>(null, -1);
        private final ConcurrentMap<PropertyListener<?>, Property.Subscription> oldSubscriptions = new ConcurrentHashMap();

        public PropertyImpl(KeyAndType<T> keyAndType, Supplier<T> supplier) {
            this.keyAndType = keyAndType;
            this.supplier = supplier;
        }

        @Override
        public T get() {
            int latestVersion;
            int cacheVersion = this.cache.getStamp();
            if (cacheVersion != (latestVersion = DefaultPropertyFactory.this.masterVersion.get())) {
                T currentValue = this.cache.getReference();
                T newValue = null;
                try {
                    newValue = this.supplier.get();
                }
                catch (Exception e2) {
                    LOG.warn("Unable to get current version of property '{}'", (Object)((KeyAndType)this.keyAndType).key, (Object)e2);
                }
                if (this.cache.compareAndSet(currentValue, newValue, cacheVersion, latestVersion)) {
                    return newValue;
                }
            }
            return this.cache.getReference();
        }

        @Override
        public String getKey() {
            return ((KeyAndType)this.keyAndType).key;
        }

        @Override
        public Property.Subscription subscribe(final Consumer<T> consumer) {
            Runnable action2 = new Runnable(){
                private T current;
                {
                    this.current = PropertyImpl.this.get();
                }

                @Override
                public synchronized void run() {
                    Object newValue = PropertyImpl.this.get();
                    if (this.current == newValue && this.current == null) {
                        return;
                    }
                    if (this.current == null) {
                        this.current = newValue;
                    } else if (newValue == null) {
                        this.current = null;
                    } else {
                        if (this.current.equals(newValue)) {
                            return;
                        }
                        this.current = newValue;
                    }
                    consumer.accept(this.current);
                }
            };
            DefaultPropertyFactory.this.listeners.add(action2);
            return () -> DefaultPropertyFactory.this.listeners.remove(action2);
        }

        @Override
        @Deprecated
        public void addListener(final PropertyListener<T> listener) {
            Property.Subscription cancel = this.onChange(new Consumer<T>(){

                @Override
                public void accept(T t) {
                    listener.accept(t);
                }
            });
            this.oldSubscriptions.put(listener, cancel);
        }

        @Override
        @Deprecated
        public void removeListener(PropertyListener<T> listener) {
            Optional.ofNullable(this.oldSubscriptions.remove(listener)).ifPresent(Property.Subscription::unsubscribe);
        }

        @Override
        public Property<T> orElse(T defaultValue) {
            return new PropertyImpl<Object>(this.keyAndType, () -> Optional.ofNullable(this.supplier.get()).orElse(defaultValue));
        }

        @Override
        public Property<T> orElseGet(String key2) {
            if (!this.keyAndType.hasType()) {
                throw new IllegalStateException("Type information lost due to map() operation.  All calls to orElse[Get] must be made prior to calling map");
            }
            KeyAndType<T> keyAndType = this.keyAndType.withKey(key2);
            Property next2 = DefaultPropertyFactory.this.get(key2, ((KeyAndType)keyAndType).type);
            return new PropertyImpl<Object>(keyAndType, () -> Optional.ofNullable(this.supplier.get()).orElseGet(next2));
        }

        @Override
        public <S> Property<S> map(Function<T, S> mapper) {
            return new PropertyImpl<Object>(this.keyAndType.discardType(), () -> {
                T value = this.supplier.get();
                if (value != null) {
                    return mapper.apply(value);
                }
                return null;
            });
        }
    }
}

