/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.DependentConfigListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompositeConfig
extends AbstractConfig
implements CompositeConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompositeConfig.class);
    private final ConfigListener listener;
    private final boolean reversed;
    private volatile State state;

    public static Builder builder() {
        return new Builder();
    }

    public static CompositeConfig create() throws ConfigException {
        return DefaultCompositeConfig.builder().build();
    }

    public DefaultCompositeConfig() {
        this(false);
    }

    public DefaultCompositeConfig(boolean reversed) {
        this.reversed = reversed;
        this.listener = new CompositeConfigListener(this);
        this.state = new State(Collections.emptyMap(), 0);
    }

    private void refreshState() {
        this.state = this.state.refresh();
    }

    @Override
    public synchronized boolean addConfig(String name2, Config child) throws ConfigException {
        return this.internalAddConfig(name2, child);
    }

    private synchronized boolean internalAddConfig(String name2, Config child) throws ConfigException {
        LOG.info("Adding config {} to {}", (Object)name2, (Object)this.hashCode());
        if (child == null) {
            return false;
        }
        if (name2 == null) {
            throw new ConfigException("Child configuration must be named");
        }
        if (this.state.containsConfig(name2)) {
            LOG.info("Configuration with name'{}' already exists", (Object)name2);
            return false;
        }
        this.state = this.state.addConfig(name2, child);
        this.postConfigAdded(child);
        return true;
    }

    @Override
    public synchronized void addConfigs(LinkedHashMap<String, Config> configs) throws ConfigException {
        for (Map.Entry<String, Config> entry : configs.entrySet()) {
            this.internalAddConfig(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void replaceConfigs(LinkedHashMap<String, Config> configs) throws ConfigException {
        for (Map.Entry<String, Config> entry : configs.entrySet()) {
            this.replaceConfig(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized Collection<String> getConfigNames() {
        return this.state.children.keySet();
    }

    protected void postConfigAdded(Config child) {
        child.setStrInterpolator(this.getStrInterpolator());
        child.setDecoder(this.getDecoder());
        this.notifyConfigAdded(child);
        child.addListener(this.listener);
    }

    @Override
    public synchronized void replaceConfig(String name2, Config child) throws ConfigException {
        this.internalRemoveConfig(name2);
        this.internalAddConfig(name2, child);
    }

    @Override
    public synchronized Config removeConfig(String name2) {
        return this.internalRemoveConfig(name2);
    }

    public synchronized Config internalRemoveConfig(String name2) {
        Config child = this.state.getConfig(name2);
        if (child != null) {
            this.state = this.state.removeConfig(name2);
            child.removeListener(this.listener);
            this.notifyConfigRemoved(child);
        }
        return child;
    }

    @Override
    public Config getConfig(String name2) {
        return (Config)this.state.children.get(name2);
    }

    @Override
    public Object getRawProperty(String key2) {
        return this.state.data.get(key2);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.state.data.keySet().iterator();
    }

    @Override
    public synchronized <T> T accept(Config.Visitor<T> visitor) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        if (visitor instanceof CompositeConfig.CompositeVisitor) {
            CompositeConfig.CompositeVisitor cv = (CompositeConfig.CompositeVisitor)visitor;
            this.state.children.forEach((key2, config) -> result.set(cv.visitChild((String)key2, (Config)config)));
        } else {
            this.state.data.forEach(visitor::visitKey);
        }
        return result.get();
    }

    public static CompositeConfig from(LinkedHashMap<String, Config> load2) throws ConfigException {
        Builder builder = DefaultCompositeConfig.builder();
        for (Map.Entry<String, Config> config : load2.entrySet()) {
            builder.withConfig(config.getKey(), config.getValue());
        }
        return builder.build();
    }

    @Override
    public boolean containsKey(String key2) {
        return this.state.data.containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.state.data.isEmpty();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.state.data.forEach(consumer);
    }

    public String toString() {
        return "[" + this.state.children.keySet().stream().collect(Collectors.joining(" ")) + "]";
    }

    private static class CompositeConfigListener
    extends DependentConfigListener<DefaultCompositeConfig> {
        private CompositeConfigListener(DefaultCompositeConfig config) {
            super(config);
        }

        @Override
        public void onSourceConfigAdded(DefaultCompositeConfig dcc, Config config) {
            dcc.refreshState();
            dcc.notifyConfigAdded(dcc);
        }

        @Override
        public void onSourceConfigRemoved(DefaultCompositeConfig dcc, Config config) {
            dcc.refreshState();
            dcc.notifyConfigRemoved(dcc);
        }

        @Override
        public void onSourceConfigUpdated(DefaultCompositeConfig dcc, Config config) {
            dcc.refreshState();
            dcc.notifyConfigUpdated(dcc);
        }

        @Override
        public void onSourceError(Throwable error, DefaultCompositeConfig dcc, Config config) {
            dcc.notifyError(error, dcc);
        }
    }

    private class State {
        private final Map<String, Config> children;
        private final Map<String, Object> data;

        public State(Map<String, Config> children2, int size) {
            this.children = children2;
            this.data = new HashMap<String, Object>(size);
            children2.values().forEach(child -> child.forEachProperty(this.data::putIfAbsent));
        }

        State addConfig(String name2, Config config) {
            LinkedHashMap<String, Config> children2 = new LinkedHashMap<String, Config>(this.children.size() + 1);
            if (DefaultCompositeConfig.this.reversed) {
                children2.put(name2, config);
                children2.putAll(this.children);
            } else {
                children2.putAll(this.children);
                children2.put(name2, config);
            }
            return new State(children2, this.data.size() + 16);
        }

        State removeConfig(String name2) {
            if (this.children.containsKey(name2)) {
                LinkedHashMap<String, Config> children2 = new LinkedHashMap<String, Config>(this.children);
                children2.remove(name2);
                return new State(children2, this.data.size());
            }
            return this;
        }

        public State refresh() {
            return new State(this.children, this.data.size());
        }

        Config getConfig(String name2) {
            return this.children.get(name2);
        }

        boolean containsConfig(String name2) {
            return this.getConfig(name2) != null;
        }
    }

    public static class Builder {
        LinkedHashMap<String, Config> configs = new LinkedHashMap();

        public Builder withConfig(String name2, Config config) {
            this.configs.put(name2, config);
            return this;
        }

        public CompositeConfig build() throws ConfigException {
            DefaultCompositeConfig config = new DefaultCompositeConfig();
            for (Map.Entry<String, Config> entry : this.configs.entrySet()) {
                config.addConfig(entry.getKey(), entry.getValue());
            }
            return config;
        }
    }
}

