/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.config.AbstractConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class MapConfig
extends AbstractConfig {
    private Map<String, String> props = new HashMap<String, String>();

    public static Builder builder() {
        return new Builder();
    }

    public static MapConfig from(Properties props) {
        return new MapConfig(props);
    }

    public static MapConfig from(Map<String, String> props) {
        return new MapConfig(props);
    }

    public MapConfig(String name2, Map<String, String> props) {
        super(name2);
        this.props.putAll(props);
        this.props = Collections.unmodifiableMap(this.props);
    }

    public MapConfig(Map<String, String> props) {
        super(MapConfig.generateUniqueName("immutable-"));
        this.props.putAll(props);
        this.props = Collections.unmodifiableMap(this.props);
    }

    public MapConfig(Properties props) {
        super(MapConfig.generateUniqueName("immutable-"));
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.props = Collections.unmodifiableMap(this.props);
    }

    @Override
    public Object getRawProperty(String key2) {
        return this.props.get(key2);
    }

    @Override
    public boolean containsKey(String key2) {
        return this.props.containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.props.forEach(consumer);
    }

    public static class Builder {
        Map<String, String> map = new HashMap<String, String>();
        String named;

        public <T> Builder put(String key2, T value) {
            this.map.put(key2, value.toString());
            return this;
        }

        public <T> Builder putAll(Map<String, String> props) {
            this.map.putAll(props);
            return this;
        }

        public <T> Builder putAll(Properties props) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.map.put(k.toString(), v.toString())));
            return this;
        }

        public Builder name(String name2) {
            this.named = name2;
            return this;
        }

        public MapConfig build() {
            return new MapConfig(this.named == null ? AbstractConfig.generateUniqueName("immutable-") : this.named, this.map);
        }
    }
}

