/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.config.PollingStrategy;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.polling.PollingResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingDynamicConfig
extends AbstractConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PollingDynamicConfig.class);
    private volatile Map<String, String> current = new HashMap<String, String>();
    private final AtomicBoolean busy = new AtomicBoolean();
    private final Callable<PollingResponse> reader;
    private final AtomicLong updateCounter = new AtomicLong();
    private final AtomicLong errorCounter = new AtomicLong();
    private final PollingStrategy strategy;

    public PollingDynamicConfig(Callable<PollingResponse> reader2, PollingStrategy strategy) {
        this.reader = reader2;
        this.strategy = strategy;
        strategy.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PollingDynamicConfig.this.update();
                }
                catch (Exception e2) {
                    throw new RuntimeException("Failed to poll configuration", e2);
                }
            }
        });
    }

    @Override
    public boolean containsKey(String key2) {
        return this.current.containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.current.isEmpty();
    }

    @Override
    public Object getRawProperty(String key2) {
        return this.current.get(key2);
    }

    private void update() throws Exception {
        if (this.busy.compareAndSet(false, true)) {
            this.updateCounter.incrementAndGet();
            try {
                PollingResponse response = this.reader.call();
                if (response.hasData()) {
                    this.current = response.getToAdd();
                    this.notifyConfigUpdated(this);
                }
            }
            catch (Exception e2) {
                LOG.trace("Error reading data from remote server ", e2);
                this.errorCounter.incrementAndGet();
                try {
                    this.notifyError(e2, this);
                }
                catch (Exception e22) {
                    LOG.warn("Failed to notify error observer", e22);
                }
                throw e2;
            }
            finally {
                this.busy.set(false);
            }
        }
    }

    public void shutdown() {
        this.strategy.shutdown();
    }

    public long getUpdateCounter() {
        return this.updateCounter.get();
    }

    public long getErrorCounter() {
        return this.errorCounter.get();
    }

    @Override
    public Iterator<String> getKeys() {
        return this.current.keySet().iterator();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.current.forEach(consumer);
    }
}

