/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.converters;

import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.exceptions.ParseException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;

public final class DefaultTypeConverterFactory
implements TypeConverter.Factory {
    public static final DefaultTypeConverterFactory INSTANCE = new DefaultTypeConverterFactory();
    private Map<Type, TypeConverter<?>> converters = new HashMap();

    private static Boolean convertBoolean(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        throw new ParseException("Error parsing value '" + value + "'", new Exception("Expected one of [true, yes, on, false, no, off]"));
    }

    private DefaultTypeConverterFactory() {
        this.converters.put((Type)((Object)String.class), DefaultTypeConverterFactory.create(Function.identity()));
        this.converters.put(Boolean.TYPE, DefaultTypeConverterFactory.create(DefaultTypeConverterFactory::convertBoolean));
        this.converters.put((Type)((Object)Boolean.class), DefaultTypeConverterFactory.create(DefaultTypeConverterFactory::convertBoolean));
        this.converters.put((Type)((Object)Integer.class), DefaultTypeConverterFactory.create(Integer::valueOf));
        this.converters.put(Integer.TYPE, DefaultTypeConverterFactory.create(Integer::valueOf));
        this.converters.put(Long.TYPE, DefaultTypeConverterFactory.create(Long::valueOf));
        this.converters.put((Type)((Object)Long.class), DefaultTypeConverterFactory.create(Long::valueOf));
        this.converters.put(Short.TYPE, DefaultTypeConverterFactory.create(Short::valueOf));
        this.converters.put((Type)((Object)Short.class), DefaultTypeConverterFactory.create(Short::valueOf));
        this.converters.put(Byte.TYPE, DefaultTypeConverterFactory.create(Byte::valueOf));
        this.converters.put((Type)((Object)Byte.class), DefaultTypeConverterFactory.create(Byte::valueOf));
        this.converters.put(Double.TYPE, DefaultTypeConverterFactory.create(Double::valueOf));
        this.converters.put((Type)((Object)Double.class), DefaultTypeConverterFactory.create(Double::valueOf));
        this.converters.put(Float.TYPE, DefaultTypeConverterFactory.create(Float::valueOf));
        this.converters.put((Type)((Object)Float.class), DefaultTypeConverterFactory.create(Float::valueOf));
        this.converters.put((Type)((Object)BigInteger.class), DefaultTypeConverterFactory.create(BigInteger::new));
        this.converters.put((Type)((Object)BigDecimal.class), DefaultTypeConverterFactory.create(BigDecimal::new));
        this.converters.put((Type)((Object)AtomicInteger.class), DefaultTypeConverterFactory.create(v -> new AtomicInteger(Integer.parseInt(v))));
        this.converters.put((Type)((Object)AtomicLong.class), DefaultTypeConverterFactory.create(v -> new AtomicLong(Long.parseLong(v))));
        this.converters.put((Type)((Object)Duration.class), DefaultTypeConverterFactory.create(Duration::parse));
        this.converters.put((Type)((Object)Period.class), DefaultTypeConverterFactory.create(Period::parse));
        this.converters.put((Type)((Object)LocalDateTime.class), DefaultTypeConverterFactory.create(LocalDateTime::parse));
        this.converters.put((Type)((Object)LocalDate.class), DefaultTypeConverterFactory.create(LocalDate::parse));
        this.converters.put((Type)((Object)LocalTime.class), DefaultTypeConverterFactory.create(LocalTime::parse));
        this.converters.put((Type)((Object)OffsetDateTime.class), DefaultTypeConverterFactory.create(OffsetDateTime::parse));
        this.converters.put((Type)((Object)OffsetTime.class), DefaultTypeConverterFactory.create(OffsetTime::parse));
        this.converters.put((Type)((Object)ZonedDateTime.class), DefaultTypeConverterFactory.create(ZonedDateTime::parse));
        this.converters.put((Type)((Object)Instant.class), DefaultTypeConverterFactory.create(v -> Instant.from(OffsetDateTime.parse(v))));
        this.converters.put((Type)((Object)Date.class), DefaultTypeConverterFactory.create(v -> new Date(Long.parseLong(v))));
        this.converters.put((Type)((Object)Currency.class), DefaultTypeConverterFactory.create(Currency::getInstance));
        this.converters.put((Type)((Object)BitSet.class), DefaultTypeConverterFactory.create(v -> BitSet.valueOf(DatatypeConverter.parseHexBinary((String)v))));
    }

    private static <T> TypeConverter<T> create(Function<String, T> func) {
        assert (func != null);
        return s -> func.apply(s);
    }

    @Override
    public Optional<TypeConverter<?>> get(Type type2, TypeConverter.Registry registry) {
        assert (type2 != null);
        assert (registry != null);
        for (Map.Entry<Type, TypeConverter<?>> entry : this.converters.entrySet()) {
            if (!entry.getKey().equals(type2)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }
}

