/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.property;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyContainer;
import com.netflix.archaius.api.PropertyListener;
import com.netflix.archaius.property.ListenerManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultPropertyContainer
implements PropertyContainer {
    private final Logger LOG = LoggerFactory.getLogger(DefaultPropertyContainer.class);
    private final String key;
    private final Config config;
    private final CopyOnWriteArrayList<CachedProperty<?>> cache = new CopyOnWriteArrayList();
    private final ListenerManager listeners;
    private final AtomicInteger masterVersion;
    private volatile long lastUpdateTimeInMillis = 0L;

    public DefaultPropertyContainer(String key2, Config config, AtomicInteger version, ListenerManager listeners) {
        this.key = key2;
        this.config = config;
        this.listeners = listeners;
        this.masterVersion = version;
    }

    private <T> CachedProperty<T> add(CachedProperty<T> newProperty) {
        while (!this.cache.add(newProperty)) {
            for (CachedProperty<?> property : this.cache) {
                if (!property.equals(newProperty)) continue;
                return property;
            }
        }
        return newProperty;
    }

    @Override
    public Property<String> asString(String defaultValue) {
        return this.add(new CachedProperty<String>(Type.STRING, defaultValue){

            @Override
            protected String resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getString(DefaultPropertyContainer.this.key, null);
            }
        });
    }

    @Override
    public Property<Integer> asInteger(Integer defaultValue) {
        return this.add(new CachedProperty<Integer>(Type.INTEGER, defaultValue){

            @Override
            protected Integer resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getInteger(DefaultPropertyContainer.this.key, null);
            }
        });
    }

    @Override
    public Property<Long> asLong(Long defaultValue) {
        return this.add(new CachedProperty<Long>(Type.LONG, defaultValue){

            @Override
            protected Long resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getLong(DefaultPropertyContainer.this.key, null);
            }
        });
    }

    @Override
    public Property<Double> asDouble(Double defaultValue) {
        return this.add(new CachedProperty<Double>(Type.DOUBLE, defaultValue){

            @Override
            protected Double resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getDouble(DefaultPropertyContainer.this.key, null);
            }
        });
    }

    @Override
    public Property<Float> asFloat(Float defaultValue) {
        return this.add(new CachedProperty<Float>(Type.FLOAT, defaultValue){

            @Override
            protected Float resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getFloat(DefaultPropertyContainer.this.key, null);
            }
        });
    }

    @Override
    public Property<Short> asShort(Short defaultValue) {
        return this.add(new CachedProperty<Short>(Type.SHORT, defaultValue){

            @Override
            protected Short resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getShort(DefaultPropertyContainer.this.key, null);
            }
        });
    }

    @Override
    public Property<Byte> asByte(final Byte defaultValue) {
        return this.add(new CachedProperty<Byte>(Type.BYTE, defaultValue){

            @Override
            protected Byte resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getByte(DefaultPropertyContainer.this.key, defaultValue);
            }
        });
    }

    @Override
    public Property<BigDecimal> asBigDecimal(final BigDecimal defaultValue) {
        return this.add(new CachedProperty<BigDecimal>(Type.BIG_DECIMAL, defaultValue){

            @Override
            protected BigDecimal resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getBigDecimal(DefaultPropertyContainer.this.key, defaultValue);
            }
        });
    }

    @Override
    public Property<Boolean> asBoolean(final Boolean defaultValue) {
        return this.add(new CachedProperty<Boolean>(Type.BOOLEAN, defaultValue){

            @Override
            protected Boolean resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getBoolean(DefaultPropertyContainer.this.key, defaultValue);
            }
        });
    }

    @Override
    public Property<BigInteger> asBigInteger(final BigInteger defaultValue) {
        return this.add(new CachedProperty<BigInteger>(Type.BIG_INTEGER, defaultValue){

            @Override
            protected BigInteger resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.getBigInteger(DefaultPropertyContainer.this.key, defaultValue);
            }
        });
    }

    @Override
    public <T> Property<T> asType(final Class<T> type2, final T defaultValue) {
        switch (Type.fromClass(type2)) {
            case INTEGER: {
                return this.asInteger((Integer)defaultValue);
            }
            case BYTE: {
                return this.asByte((Byte)defaultValue);
            }
            case SHORT: {
                return this.asShort((Short)defaultValue);
            }
            case DOUBLE: {
                return this.asDouble((Double)defaultValue);
            }
            case FLOAT: {
                return this.asFloat((Float)defaultValue);
            }
            case BOOLEAN: {
                return this.asBoolean((Boolean)defaultValue);
            }
            case STRING: {
                return this.asString((String)defaultValue);
            }
            case LONG: {
                return this.asLong((Long)defaultValue);
            }
            case BIG_DECIMAL: {
                return this.asBigDecimal((BigDecimal)defaultValue);
            }
            case BIG_INTEGER: {
                return this.asBigInteger((BigInteger)defaultValue);
            }
        }
        CachedProperty<T> prop = this.add(new CachedProperty<T>(Type.CUSTOM, defaultValue){

            @Override
            protected T resolveCurrent() throws Exception {
                return DefaultPropertyContainer.this.config.get(type2, DefaultPropertyContainer.this.key, defaultValue);
            }
        });
        return prop;
    }

    @Override
    public <T> Property<T> asType(final Function<String, T> type2, final String defaultValue) {
        return this.add(new CachedProperty<T>(Type.CUSTOM, null){

            @Override
            protected T resolveCurrent() throws Exception {
                return type2.apply(DefaultPropertyContainer.this.config.getString(DefaultPropertyContainer.this.key, defaultValue));
            }
        });
    }

    abstract class CachedProperty<T>
    implements Property<T> {
        private final AtomicStampedReference<T> cache = new AtomicStampedReference<Object>(null, -1);
        private final int type;
        private final T defaultValue;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedProperty other = (CachedProperty)obj;
            if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
                return false;
            }
            return this.type == other.type;
        }

        CachedProperty(Type type2, T defaultValue) {
            this.type = type2.ordinal();
            this.defaultValue = defaultValue;
        }

        @Override
        public void addListener(final PropertyListener<T> listener) {
            DefaultPropertyContainer.this.listeners.add(listener, new ListenerManager.ListenerUpdater(){
                private AtomicReference<T> last = new AtomicReference<Object>(null);

                @Override
                public void update() {
                    Object value;
                    Object prev2 = this.last.get();
                    try {
                        value = CachedProperty.this.get();
                    }
                    catch (Exception e2) {
                        listener.onParseError(e2);
                        return;
                    }
                    if (prev2 != value && this.last.compareAndSet(prev2, value)) {
                        listener.onChange(value);
                    }
                }
            });
        }

        @Override
        public String getKey() {
            return DefaultPropertyContainer.this.key;
        }

        @Override
        public void removeListener(PropertyListener<T> listener) {
            DefaultPropertyContainer.this.listeners.remove(listener);
        }

        @Override
        public T get() {
            int latestVersion;
            int cacheVersion = this.cache.getStamp();
            if (cacheVersion != (latestVersion = DefaultPropertyContainer.this.masterVersion.get())) {
                T currentValue = this.cache.getReference();
                T newValue = null;
                try {
                    newValue = this.resolveCurrent();
                }
                catch (Exception e2) {
                    DefaultPropertyContainer.this.LOG.warn("Unable to get current version of property '{}'", (Object)DefaultPropertyContainer.this.key, (Object)e2);
                }
                if (this.cache.compareAndSet(currentValue, newValue, cacheVersion, latestVersion)) {
                    DefaultPropertyContainer.this.lastUpdateTimeInMillis = System.currentTimeMillis();
                    return this.firstNonNull(newValue, this.defaultValue);
                }
            }
            return this.firstNonNull(this.cache.getReference(), this.defaultValue);
        }

        public long getLastUpdateTime(TimeUnit units) {
            return units.convert(DefaultPropertyContainer.this.lastUpdateTimeInMillis, TimeUnit.MILLISECONDS);
        }

        private T firstNonNull(T first2, T second) {
            return first2 == null ? second : first2;
        }

        protected abstract T resolveCurrent() throws Exception;

        private DefaultPropertyContainer getOuterType() {
            return DefaultPropertyContainer.this;
        }
    }

    static enum Type {
        INTEGER(Integer.TYPE, Integer.class),
        BYTE(Byte.TYPE, Byte.class),
        SHORT(Short.TYPE, Short.class),
        DOUBLE(Double.TYPE, Double.class),
        FLOAT(Float.TYPE, Float.class),
        BOOLEAN(Boolean.TYPE, Boolean.class),
        LONG(Long.TYPE, Long.class),
        STRING(String.class),
        BIG_DECIMAL(BigDecimal.class),
        BIG_INTEGER(BigInteger.class),
        CUSTOM(new Class[0]);

        private final Class<?>[] types;

        private Type(Class<?> ... type2) {
            this.types = type2;
        }

        static Type fromClass(Class<?> clazz) {
            for (Type type2 : Type.values()) {
                for (Class<?> cls : type2.types) {
                    if (!cls.equals(clazz)) continue;
                    return type2;
                }
            }
            return CUSTOM;
        }
    }
}

