/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorWatcher;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.NamespaceWatchedEvent;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import java.io.Closeable;

class NamespaceWatcher
implements Watcher,
Closeable {
    private volatile CuratorFrameworkImpl client;
    private volatile Watcher actualWatcher;
    private volatile CuratorWatcher curatorWatcher;

    NamespaceWatcher(CuratorFrameworkImpl client, Watcher actualWatcher) {
        this.client = client;
        this.actualWatcher = actualWatcher;
        this.curatorWatcher = null;
    }

    NamespaceWatcher(CuratorFrameworkImpl client, CuratorWatcher curatorWatcher) {
        this.client = client;
        this.actualWatcher = null;
        this.curatorWatcher = curatorWatcher;
    }

    @Override
    public void close() {
        this.client = null;
        this.actualWatcher = null;
        this.curatorWatcher = null;
    }

    @Override
    public void process(WatchedEvent event) {
        if (this.client != null) {
            if (this.actualWatcher != null) {
                this.actualWatcher.process(new NamespaceWatchedEvent(this.client, event));
            } else if (this.curatorWatcher != null) {
                try {
                    this.curatorWatcher.process(new NamespaceWatchedEvent(this.client, event));
                }
                catch (Exception e2) {
                    ThreadUtils.checkInterrupted(e2);
                    this.client.logError("Watcher exception", e2);
                }
            }
        }
    }
}

