/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.jute.BinaryInputArchive;
import io.mantisrx.shaded.org.apache.jute.BinaryOutputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.Environment;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import io.mantisrx.shaded.org.apache.zookeeper.data.Id;
import io.mantisrx.shaded.org.apache.zookeeper.data.StatPersisted;
import io.mantisrx.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import io.mantisrx.shaded.org.apache.zookeeper.proto.AuthPacket;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ConnectRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ConnectResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetSASLRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ReplyHeader;
import io.mantisrx.shaded.org.apache.zookeeper.proto.RequestHeader;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetSASLResponse;
import io.mantisrx.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTree;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTreeBean;
import io.mantisrx.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerStats;
import io.mantisrx.shaded.org.apache.zookeeper.server.SessionTracker;
import io.mantisrx.shaded.org.apache.zookeeper.server.SessionTrackerImpl;
import io.mantisrx.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.UnimplementedRequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperSaslServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServerBean;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServerListener;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServerListenerImpl;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServerShutdownHandler;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import io.mantisrx.shaded.org.apache.zookeeper.server.auth.AuthenticationProvider;
import io.mantisrx.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateSessionTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServer
implements SessionTracker.SessionExpirer,
ServerStats.Provider {
    protected static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServer.class);
    protected ZooKeeperServerBean jmxServerBean;
    protected DataTreeBean jmxDataTreeBean;
    public static final int DEFAULT_TICK_TIME = 3000;
    protected int tickTime = 3000;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected SessionTracker sessionTracker;
    private FileTxnSnapLog txnLogFactory = null;
    private ZKDatabase zkDb;
    private final AtomicLong hzxid = new AtomicLong(0L);
    public static final Exception ok;
    protected RequestProcessor firstProcessor;
    protected volatile State state = State.INITIAL;
    private static final long superSecret = 3007405056L;
    private final AtomicInteger requestsInProcess = new AtomicInteger(0);
    final List<ChangeRecord> outstandingChanges = new ArrayList<ChangeRecord>();
    final HashMap<String, ChangeRecord> outstandingChangesForPath = new HashMap();
    private ServerCnxnFactory serverCnxnFactory;
    private final ServerStats serverStats = new ServerStats(this);
    private final ZooKeeperServerListener listener;
    private ZooKeeperServerShutdownHandler zkShutdownHandler;

    void removeCnxn(ServerCnxn cnxn) {
        this.zkDb.removeCnxn(cnxn);
    }

    public ZooKeeperServer() {
        this.listener = new ZooKeeperServerListenerImpl(this);
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, DataTreeBuilder treeBuilder, ZKDatabase zkDb) {
        this.txnLogFactory = txnLogFactory;
        this.txnLogFactory.setServerStats(this.serverStats);
        this.zkDb = zkDb;
        this.tickTime = tickTime;
        this.minSessionTimeout = minSessionTimeout;
        this.maxSessionTimeout = maxSessionTimeout;
        this.listener = new ZooKeeperServerListenerImpl(this);
        LOG.info("Created server with tickTime " + tickTime + " minSessionTimeout " + this.getMinSessionTimeout() + " maxSessionTimeout " + this.getMaxSessionTimeout() + " datadir " + txnLogFactory.getDataDir() + " snapdir " + txnLogFactory.getSnapDir());
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, DataTreeBuilder treeBuilder) throws IOException {
        this(txnLogFactory, tickTime, -1, -1, treeBuilder, new ZKDatabase(txnLogFactory));
    }

    public ServerStats serverStats() {
        return this.serverStats;
    }

    public void dumpConf(PrintWriter pwriter) {
        pwriter.print("clientPort=");
        pwriter.println(this.getClientPort());
        pwriter.print("dataDir=");
        pwriter.println(this.zkDb.snapLog.getSnapDir().getAbsolutePath());
        pwriter.print("dataLogDir=");
        pwriter.println(this.zkDb.snapLog.getDataDir().getAbsolutePath());
        pwriter.print("tickTime=");
        pwriter.println(this.getTickTime());
        pwriter.print("maxClientCnxns=");
        pwriter.println(this.serverCnxnFactory.getMaxClientCnxnsPerHost());
        pwriter.print("minSessionTimeout=");
        pwriter.println(this.getMinSessionTimeout());
        pwriter.print("maxSessionTimeout=");
        pwriter.println(this.getMaxSessionTimeout());
        pwriter.print("serverId=");
        pwriter.println(this.getServerId());
    }

    public ZooKeeperServer(File snapDir, File logDir, int tickTime) throws IOException {
        this(new FileTxnSnapLog(snapDir, logDir), tickTime, new BasicDataTreeBuilder());
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, DataTreeBuilder treeBuilder) throws IOException {
        this(txnLogFactory, 3000, -1, -1, treeBuilder, new ZKDatabase(txnLogFactory));
    }

    public ZKDatabase getZKDatabase() {
        return this.zkDb;
    }

    public void setZKDatabase(ZKDatabase zkDb) {
        this.zkDb = zkDb;
    }

    public void loadData() throws IOException, InterruptedException {
        if (this.zkDb.isInitialized()) {
            this.setZxid(this.zkDb.getDataTreeLastProcessedZxid());
        } else {
            this.setZxid(this.zkDb.loadDataBase());
        }
        LinkedList<Long> deadSessions = new LinkedList<Long>();
        for (Long session : this.zkDb.getSessions()) {
            if (this.zkDb.getSessionWithTimeOuts().get(session) != null) continue;
            deadSessions.add(session);
        }
        this.zkDb.setDataTreeInit(true);
        for (long session : deadSessions) {
            this.killSession(session, this.zkDb.getDataTreeLastProcessedZxid());
        }
    }

    public void takeSnapshot() {
        try {
            this.txnLogFactory.save(this.zkDb.getDataTree(), this.zkDb.getSessionWithTimeOuts());
        }
        catch (IOException e2) {
            LOG.error("Severe unrecoverable error, exiting", e2);
            System.exit(10);
        }
    }

    public long getZxid() {
        return this.hzxid.get();
    }

    long getNextZxid() {
        return this.hzxid.incrementAndGet();
    }

    public void setZxid(long zxid) {
        this.hzxid.set(zxid);
    }

    private void close(long sessionId) {
        this.submitRequest(null, sessionId, -11, 0, null, null);
    }

    public void closeSession(long sessionId) {
        LOG.info("Closing session 0x" + Long.toHexString(sessionId));
        this.close(sessionId);
    }

    protected void killSession(long sessionId, long zxid) {
        this.zkDb.killSession(sessionId, zxid);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- killSession: 0x" + Long.toHexString(sessionId));
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.removeSession(sessionId);
        }
    }

    @Override
    public void expire(SessionTracker.Session session) {
        long sessionId = session.getSessionId();
        LOG.info("Expiring session 0x" + Long.toHexString(sessionId) + ", timeout of " + session.getTimeout() + "ms exceeded");
        this.close(sessionId);
    }

    void touch(ServerCnxn cnxn) throws MissingSessionException {
        int to;
        if (cnxn == null) {
            return;
        }
        long id = cnxn.getSessionId();
        if (!this.sessionTracker.touchSession(id, to = cnxn.getSessionTimeout())) {
            throw new MissingSessionException("No session with sessionid 0x" + Long.toHexString(id) + " exists, probably expired and removed");
        }
    }

    protected void registerJMX() {
        try {
            this.jmxServerBean = new ZooKeeperServerBean(this);
            MBeanRegistry.getInstance().register(this.jmxServerBean, null);
            try {
                this.jmxDataTreeBean = new DataTreeBean(this.zkDb.getDataTree());
                MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
            }
            catch (Exception e2) {
                LOG.warn("Failed to register with JMX", e2);
                this.jmxDataTreeBean = null;
            }
        }
        catch (Exception e3) {
            LOG.warn("Failed to register with JMX", e3);
            this.jmxServerBean = null;
        }
    }

    public void startdata() throws IOException, InterruptedException {
        if (this.zkDb == null) {
            this.zkDb = new ZKDatabase(this.txnLogFactory);
        }
        if (!this.zkDb.isInitialized()) {
            this.loadData();
        }
    }

    public synchronized void startup() {
        if (this.sessionTracker == null) {
            this.createSessionTracker();
        }
        this.startSessionTracker();
        this.setupRequestProcessors();
        this.registerJMX();
        this.setState(State.RUNNING);
        this.notifyAll();
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this, finalProcessor);
        syncProcessor.start();
        this.firstProcessor = new PrepRequestProcessor(this, syncProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    public ZooKeeperServerListener getZooKeeperServerListener() {
        return this.listener;
    }

    protected void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.zkDb.getSessionWithTimeOuts(), this.tickTime, 1L, this.getZooKeeperServerListener());
    }

    protected void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    protected void setState(State state) {
        this.state = state;
        if (this.zkShutdownHandler != null) {
            this.zkShutdownHandler.handle(state);
        } else {
            LOG.debug("ZKShutdownHandler is not registered, so ZooKeeper server won't take any action on ERROR or SHUTDOWN server state changes");
        }
    }

    protected boolean canShutdown() {
        return this.state == State.RUNNING || this.state == State.ERROR;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean fullyShutDown) {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        LOG.info("shutting down");
        this.setState(State.SHUTDOWN);
        if (this.sessionTracker != null) {
            this.sessionTracker.shutdown();
        }
        if (this.firstProcessor != null) {
            this.firstProcessor.shutdown();
        }
        if (this.zkDb != null) {
            if (fullyShutDown) {
                this.zkDb.clear();
            } else {
                try {
                    this.zkDb.fastForwardDataBase();
                }
                catch (IOException e2) {
                    LOG.error("Error updating DB", e2);
                    this.zkDb.clear();
                }
            }
        }
        this.unregisterJMX();
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e2) {
            LOG.warn("Failed to unregister with JMX", e2);
        }
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e3) {
            LOG.warn("Failed to unregister with JMX", e3);
        }
        this.jmxServerBean = null;
        this.jmxDataTreeBean = null;
    }

    public void incInProcess() {
        this.requestsInProcess.incrementAndGet();
    }

    public void decInProcess() {
        this.requestsInProcess.decrementAndGet();
    }

    public int getInProcess() {
        return this.requestsInProcess.get();
    }

    byte[] generatePasswd(long id) {
        Random r = new Random(id ^ 0xB3415C00L);
        byte[] p = new byte[16];
        r.nextBytes(p);
        return p;
    }

    protected boolean checkPasswd(long sessionId, byte[] passwd) {
        return sessionId != 0L && Arrays.equals(passwd, this.generatePasswd(sessionId));
    }

    long createSession(ServerCnxn cnxn, byte[] passwd, int timeout) {
        long sessionId = this.sessionTracker.createSession(timeout);
        Random r = new Random(sessionId ^ 0xB3415C00L);
        r.nextBytes(passwd);
        ByteBuffer to = ByteBuffer.allocate(4);
        to.putInt(timeout);
        cnxn.setSessionId(sessionId);
        this.submitRequest(cnxn, sessionId, -10, 0, to, null);
        return sessionId;
    }

    public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        this.sessionTracker.setOwner(id, owner);
    }

    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        boolean rc = this.sessionTracker.touchSession(sessionId, sessionTimeout);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + rc);
        }
        this.finishSessionInit(cnxn, rc);
    }

    public void reopenSession(ServerCnxn cnxn, long sessionId, byte[] passwd, int sessionTimeout) throws IOException {
        if (!this.checkPasswd(sessionId, passwd)) {
            this.finishSessionInit(cnxn, false);
        } else {
            this.revalidateSession(cnxn, sessionId, sessionTimeout);
        }
    }

    public void finishSessionInit(ServerCnxn cnxn, boolean valid) {
        try {
            if (valid) {
                this.serverCnxnFactory.registerConnection(cnxn);
            }
        }
        catch (Exception e2) {
            LOG.warn("Failed to register with JMX", e2);
        }
        try {
            ConnectResponse rsp = new ConnectResponse(0, valid ? cnxn.getSessionTimeout() : 0, valid ? cnxn.getSessionId() : 0L, valid ? this.generatePasswd(cnxn.getSessionId()) : new byte[16]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            bos.writeInt(-1, "len");
            rsp.serialize(bos, "connect");
            if (!cnxn.isOldClient) {
                bos.writeBool(this instanceof ReadOnlyZooKeeperServer, "readOnly");
            }
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.remaining() - 4).rewind();
            cnxn.sendBuffer(bb);
            if (!valid) {
                LOG.info("Invalid session 0x" + Long.toHexString(cnxn.getSessionId()) + " for client " + cnxn.getRemoteSocketAddress() + ", probably expired");
                cnxn.sendBuffer(ServerCnxnFactory.closeConn);
            } else {
                LOG.info("Established session 0x" + Long.toHexString(cnxn.getSessionId()) + " with negotiated timeout " + cnxn.getSessionTimeout() + " for client " + cnxn.getRemoteSocketAddress());
                cnxn.enableRecv();
            }
        }
        catch (Exception e3) {
            LOG.warn("Exception while establishing session, closing", e3);
            cnxn.close();
        }
    }

    public void closeSession(ServerCnxn cnxn, RequestHeader requestHeader) {
        this.closeSession(cnxn.getSessionId());
    }

    @Override
    public long getServerId() {
        return 0L;
    }

    private void submitRequest(ServerCnxn cnxn, long sessionId, int type2, int xid, ByteBuffer bb, List<Id> authInfo) {
        Request si = new Request(cnxn, sessionId, xid, type2, bb, authInfo);
        this.submitRequest(si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(Request si) {
        if (this.firstProcessor == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (this.state == State.INITIAL) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e2) {
                    LOG.warn("Unexpected interruption", e2);
                }
                if (this.firstProcessor == null || this.state != State.RUNNING) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        try {
            this.touch(si.cnxn);
            boolean validpacket = Request.isValid(si.type);
            if (validpacket) {
                this.firstProcessor.processRequest(si);
                if (si.cnxn != null) {
                    this.incInProcess();
                }
            } else {
                LOG.warn("Received packet at server of unknown type " + si.type);
                new UnimplementedRequestProcessor().processRequest(si);
            }
        }
        catch (MissingSessionException e3) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dropping request: " + e3.getMessage());
            }
        }
        catch (RequestProcessor.RequestProcessorException e4) {
            LOG.error("Unable to process request:" + e4.getMessage(), e4);
        }
    }

    public static int getSnapCount() {
        String sc = System.getProperty("zookeeper.snapCount");
        try {
            int snapCount = Integer.parseInt(sc);
            if (snapCount < 2) {
                LOG.warn("SnapCount should be 2 or more. Now, snapCount is reset to 2");
                snapCount = 2;
            }
            return snapCount;
        }
        catch (Exception e2) {
            return 100000;
        }
    }

    public int getGlobalOutstandingLimit() {
        int limit2;
        String sc = System.getProperty("zookeeper.globalOutstandingLimit");
        try {
            limit2 = Integer.parseInt(sc);
        }
        catch (Exception e2) {
            limit2 = 1000;
        }
        return limit2;
    }

    public void setServerCnxnFactory(ServerCnxnFactory factory) {
        this.serverCnxnFactory = factory;
    }

    public ServerCnxnFactory getServerCnxnFactory() {
        return this.serverCnxnFactory;
    }

    @Override
    public long getLastProcessedZxid() {
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    @Override
    public long getOutstandingRequests() {
        return this.getInProcess();
    }

    public void truncateLog(long zxid) throws IOException {
        this.zkDb.truncateLog(zxid);
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        LOG.info("tickTime set to " + tickTime);
        this.tickTime = tickTime;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int min2) {
        LOG.info("minSessionTimeout set to " + min2);
        this.minSessionTimeout = min2;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int max2) {
        LOG.info("maxSessionTimeout set to " + max2);
        this.maxSessionTimeout = max2;
    }

    public int getClientPort() {
        return this.serverCnxnFactory != null ? this.serverCnxnFactory.getLocalPort() : -1;
    }

    public void setTxnLogFactory(FileTxnSnapLog txnLog) {
        this.txnLogFactory = txnLog;
    }

    public FileTxnSnapLog getTxnLogFactory() {
        return this.txnLogFactory;
    }

    @Override
    public String getState() {
        return "standalone";
    }

    public void dumpEphemerals(PrintWriter pwriter) {
        this.zkDb.dumpEphemerals(pwriter);
    }

    @Override
    public int getNumAliveConnections() {
        return this.serverCnxnFactory.getNumAliveConnections();
    }

    public void processConnectRequest(ServerCnxn cnxn, ByteBuffer incomingBuffer) throws IOException {
        int maxSessionTimeout;
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(incomingBuffer));
        ConnectRequest connReq = new ConnectRequest();
        connReq.deserialize(bia, "connect");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session establishment request from client " + cnxn.getRemoteSocketAddress() + " client's lastZxid is 0x" + Long.toHexString(connReq.getLastZxidSeen()));
        }
        boolean readOnly = false;
        try {
            readOnly = bia.readBool("readOnly");
            cnxn.isOldClient = false;
        }
        catch (IOException e2) {
            LOG.warn("Connection request from old client " + cnxn.getRemoteSocketAddress() + "; will be dropped if server is in r-o mode");
        }
        if (!readOnly && this instanceof ReadOnlyZooKeeperServer) {
            String msg = "Refusing session request for not-read-only client " + cnxn.getRemoteSocketAddress();
            LOG.info(msg);
            throw new ServerCnxn.CloseRequestException(msg);
        }
        if (connReq.getLastZxidSeen() > this.zkDb.dataTree.lastProcessedZxid) {
            String msg = "Refusing session request for client " + cnxn.getRemoteSocketAddress() + " as it has seen zxid 0x" + Long.toHexString(connReq.getLastZxidSeen()) + " our last zxid is 0x" + Long.toHexString(this.getZKDatabase().getDataTreeLastProcessedZxid()) + " client must try another server";
            LOG.info(msg);
            throw new ServerCnxn.CloseRequestException(msg);
        }
        int sessionTimeout = connReq.getTimeOut();
        byte[] passwd = connReq.getPasswd();
        int minSessionTimeout = this.getMinSessionTimeout();
        if (sessionTimeout < minSessionTimeout) {
            sessionTimeout = minSessionTimeout;
        }
        if (sessionTimeout > (maxSessionTimeout = this.getMaxSessionTimeout())) {
            sessionTimeout = maxSessionTimeout;
        }
        cnxn.setSessionTimeout(sessionTimeout);
        cnxn.disableRecv();
        long sessionId = connReq.getSessionId();
        if (sessionId != 0L) {
            long clientSessionId = connReq.getSessionId();
            LOG.info("Client attempting to renew session 0x" + Long.toHexString(clientSessionId) + " at " + cnxn.getRemoteSocketAddress());
            this.serverCnxnFactory.closeSession(sessionId);
            cnxn.setSessionId(sessionId);
            this.reopenSession(cnxn, sessionId, passwd, sessionTimeout);
        } else {
            LOG.info("Client attempting to establish new session at " + cnxn.getRemoteSocketAddress());
            this.createSession(cnxn, passwd, sessionTimeout);
        }
    }

    public boolean shouldThrottle(long outStandingCount) {
        if (this.getGlobalOutstandingLimit() < this.getInProcess()) {
            return outStandingCount > 0L;
        }
        return false;
    }

    public void processPacket(ServerCnxn cnxn, ByteBuffer incomingBuffer) throws IOException {
        ByteBufferInputStream bais = new ByteBufferInputStream(incomingBuffer);
        BinaryInputArchive bia = BinaryInputArchive.getArchive(bais);
        RequestHeader h = new RequestHeader();
        h.deserialize(bia, "header");
        incomingBuffer = incomingBuffer.slice();
        if (h.getType() == 100) {
            LOG.info("got auth packet " + cnxn.getRemoteSocketAddress());
            AuthPacket authPacket = new AuthPacket();
            ByteBufferInputStream.byteBuffer2Record(incomingBuffer, authPacket);
            String scheme = authPacket.getScheme();
            AuthenticationProvider ap = ProviderRegistry.getProvider(scheme);
            KeeperException.Code authReturn = KeeperException.Code.AUTHFAILED;
            if (ap != null) {
                try {
                    authReturn = ap.handleAuthentication(cnxn, authPacket.getAuth());
                }
                catch (RuntimeException e2) {
                    LOG.warn("Caught runtime exception from AuthenticationProvider: " + scheme + " due to " + e2);
                    authReturn = KeeperException.Code.AUTHFAILED;
                }
            }
            if (authReturn != KeeperException.Code.OK) {
                if (ap == null) {
                    LOG.warn("No authentication provider for scheme: " + scheme + " has " + ProviderRegistry.listProviders());
                } else {
                    LOG.warn("Authentication failed for scheme: " + scheme);
                }
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.AUTHFAILED.intValue());
                cnxn.sendResponse(rh, null, null);
                cnxn.sendBuffer(ServerCnxnFactory.closeConn);
                cnxn.disableRecv();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication succeeded for scheme: " + scheme);
                }
                LOG.info("auth success " + cnxn.getRemoteSocketAddress());
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.OK.intValue());
                cnxn.sendResponse(rh, null, null);
            }
            return;
        }
        if (h.getType() == 102) {
            Record rsp = this.processSasl(incomingBuffer, cnxn);
            ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.OK.intValue());
            cnxn.sendResponse(rh, rsp, "response");
            return;
        }
        Request si = new Request(cnxn, cnxn.getSessionId(), h.getXid(), h.getType(), incomingBuffer, cnxn.getAuthInfo());
        si.setOwner(ServerCnxn.me);
        this.submitRequest(si);
        cnxn.incrOutstandingRequests(h);
    }

    private Record processSasl(ByteBuffer incomingBuffer, ServerCnxn cnxn) throws IOException {
        byte[] responseToken;
        block7: {
            LOG.debug("Responding to client SASL token.");
            GetSASLRequest clientTokenRecord = new GetSASLRequest();
            ByteBufferInputStream.byteBuffer2Record(incomingBuffer, clientTokenRecord);
            byte[] clientToken = clientTokenRecord.getToken();
            LOG.debug("Size of client SASL token: " + clientToken.length);
            responseToken = null;
            try {
                ZooKeeperSaslServer saslServer = cnxn.zooKeeperSaslServer;
                try {
                    responseToken = saslServer.evaluateResponse(clientToken);
                    if (saslServer.isComplete()) {
                        String authorizationID = saslServer.getAuthorizationID();
                        LOG.info("adding SASL authorization for authorizationID: " + authorizationID);
                        cnxn.addAuthInfo(new Id("sasl", authorizationID));
                    }
                }
                catch (SaslException e2) {
                    LOG.warn("Client failed to SASL authenticate: " + e2, e2);
                    if (System.getProperty("zookeeper.allowSaslFailedClients") != null && System.getProperty("zookeeper.allowSaslFailedClients").equals("true")) {
                        LOG.warn("Maintaining client connection despite SASL authentication failure.");
                        break block7;
                    }
                    LOG.warn("Closing client connection due to SASL authentication failure.");
                    cnxn.close();
                }
            }
            catch (NullPointerException e3) {
                LOG.error("cnxn.saslServer is null: cnxn object did not initialize its saslServer properly.");
            }
        }
        if (responseToken != null) {
            LOG.debug("Size of server SASL response: " + responseToken.length);
        }
        return new SetSASLResponse(responseToken);
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader hdr, Record txn) {
        int opCode = hdr.getType();
        long sessionId = hdr.getClientId();
        DataTree.ProcessTxnResult rc = this.getZKDatabase().processTxn(hdr, txn);
        if (opCode == -10) {
            if (txn instanceof CreateSessionTxn) {
                CreateSessionTxn cst = (CreateSessionTxn)txn;
                this.sessionTracker.addSession(sessionId, cst.getTimeOut());
            } else {
                LOG.warn("*****>>>>> Got " + txn.getClass() + " " + txn.toString());
            }
        } else if (opCode == -11) {
            this.sessionTracker.removeSession(sessionId);
        }
        return rc;
    }

    void registerServerShutdownHandler(ZooKeeperServerShutdownHandler zkShutdownHandler) {
        this.zkShutdownHandler = zkShutdownHandler;
    }

    static {
        Environment.logEnv("Server environment:", LOG);
        ok = new Exception("No prob");
    }

    static class ChangeRecord {
        long zxid;
        String path;
        StatPersisted stat;
        int childCount;
        List<ACL> acl;

        ChangeRecord(long zxid, String path2, StatPersisted stat, int childCount, List<ACL> acl) {
            this.zxid = zxid;
            this.path = path2;
            this.stat = stat;
            this.childCount = childCount;
            this.acl = acl;
        }

        ChangeRecord duplicate(long zxid) {
            StatPersisted stat = new StatPersisted();
            if (this.stat != null) {
                DataTree.copyStatPersisted(this.stat, stat);
            }
            return new ChangeRecord(zxid, this.path, stat, this.childCount, this.acl == null ? new ArrayList<ACL>() : new ArrayList<ACL>(this.acl));
        }
    }

    public static class MissingSessionException
    extends IOException {
        private static final long serialVersionUID = 7467414635467261007L;

        public MissingSessionException(String msg) {
            super(msg);
        }
    }

    protected static enum State {
        INITIAL,
        RUNNING,
        SHUTDOWN,
        ERROR;

    }

    public static class BasicDataTreeBuilder
    implements DataTreeBuilder {
        @Override
        public DataTree build() {
            return new DataTree();
        }
    }

    public static interface DataTreeBuilder {
        public DataTree build();
    }
}

