/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelDownstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.DownstreamMessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpChunk;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpHeaders;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyHeaders;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public class SpdyHttpEncoder
implements ChannelDownstreamHandler {
    private final int spdyVersion;
    private volatile int currentStreamId;

    public SpdyHttpEncoder(int version) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        this.spdyVersion = version;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e2 = (MessageEvent)evt;
        Object msg = e2.getMessage();
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpRequest);
            this.currentStreamId = spdySynStreamFrame.getStreamId();
            ChannelFuture future2 = this.getMessageFuture(ctx, e2, this.currentStreamId, httpRequest);
            Channels.write(ctx, future2, spdySynStreamFrame, e2.getRemoteAddress());
        } else if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            if (httpResponse.containsHeader("X-SPDY-Associated-To-Stream-ID")) {
                SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpResponse);
                this.currentStreamId = spdySynStreamFrame.getStreamId();
                ChannelFuture future3 = this.getMessageFuture(ctx, e2, this.currentStreamId, httpResponse);
                Channels.write(ctx, future3, spdySynStreamFrame, e2.getRemoteAddress());
            } else {
                SpdySynReplyFrame spdySynReplyFrame = this.createSynReplyFrame(httpResponse);
                this.currentStreamId = spdySynReplyFrame.getStreamId();
                ChannelFuture future4 = this.getMessageFuture(ctx, e2, this.currentStreamId, httpResponse);
                Channels.write(ctx, future4, spdySynReplyFrame, e2.getRemoteAddress());
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk2 = (HttpChunk)msg;
            this.writeChunk(ctx, e2.getFuture(), this.currentStreamId, chunk2, e2.getRemoteAddress());
        } else {
            ctx.sendDownstream(evt);
        }
    }

    protected void writeChunk(ChannelHandlerContext ctx, ChannelFuture future2, int streamId, HttpChunk chunk2, SocketAddress remoteAddress) {
        if (chunk2.isLast()) {
            if (chunk2 instanceof HttpChunkTrailer) {
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk2;
                List<Map.Entry<String, String>> trailers = trailer.getHeaders();
                if (trailers.isEmpty()) {
                    DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
                    spdyDataFrame.setLast(true);
                    Channels.write(ctx, future2, spdyDataFrame, remoteAddress);
                } else {
                    DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(streamId);
                    spdyHeadersFrame.setLast(true);
                    for (Map.Entry<String, String> entry : trailers) {
                        spdyHeadersFrame.addHeader(entry.getKey(), entry.getValue());
                    }
                    Channels.write(ctx, future2, spdyHeadersFrame, remoteAddress);
                }
            } else {
                DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
                spdyDataFrame.setLast(true);
                Channels.write(ctx, future2, spdyDataFrame, remoteAddress);
            }
        } else {
            SpdyDataFrame[] spdyDataFrames = this.createSpdyDataFrames(streamId, chunk2.getContent());
            ChannelFuture dataFuture = SpdyHttpEncoder.getDataFuture(ctx, future2, spdyDataFrames, remoteAddress);
            dataFuture.setSuccess();
        }
    }

    private ChannelFuture getMessageFuture(ChannelHandlerContext ctx, MessageEvent e2, int streamId, HttpMessage httpMessage) {
        if (!httpMessage.getContent().readable()) {
            return e2.getFuture();
        }
        SpdyDataFrame[] spdyDataFrames = this.createSpdyDataFrames(streamId, httpMessage.getContent());
        if (spdyDataFrames.length > 0) {
            spdyDataFrames[spdyDataFrames.length - 1].setLast(true);
        }
        return SpdyHttpEncoder.getDataFuture(ctx, e2.getFuture(), spdyDataFrames, e2.getRemoteAddress());
    }

    private static ChannelFuture getDataFuture(ChannelHandlerContext ctx, ChannelFuture future2, SpdyDataFrame[] spdyDataFrames, SocketAddress remoteAddress) {
        ChannelFuture dataFuture = future2;
        int i = spdyDataFrames.length;
        while (--i >= 0) {
            future2 = Channels.future(ctx.getChannel());
            future2.addListener(new SpdyFrameWriter(ctx, new DownstreamMessageEvent(ctx.getChannel(), dataFuture, spdyDataFrames[i], remoteAddress)));
            dataFuture = future2;
        }
        return dataFuture;
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpMessage httpMessage) throws Exception {
        boolean chunked = httpMessage.isChunked();
        int streamId = SpdyHttpHeaders.getStreamId(httpMessage);
        int associatedToStreamId = SpdyHttpHeaders.getAssociatedToStreamId(httpMessage);
        byte priority = SpdyHttpHeaders.getPriority(httpMessage);
        String URL2 = SpdyHttpHeaders.getUrl(httpMessage);
        String scheme = SpdyHttpHeaders.getScheme(httpMessage);
        SpdyHttpHeaders.removeStreamId(httpMessage);
        SpdyHttpHeaders.removeAssociatedToStreamId(httpMessage);
        SpdyHttpHeaders.removePriority(httpMessage);
        SpdyHttpHeaders.removeUrl(httpMessage);
        SpdyHttpHeaders.removeScheme(httpMessage);
        httpMessage.removeHeader("Connection");
        httpMessage.removeHeader("Keep-Alive");
        httpMessage.removeHeader("Proxy-Connection");
        httpMessage.removeHeader("Transfer-Encoding");
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamId, associatedToStreamId, priority);
        spdySynStreamFrame.setLast(!chunked && !httpMessage.getContent().readable());
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            SpdyHeaders.setMethod(this.spdyVersion, spdySynStreamFrame, httpRequest.getMethod());
            SpdyHeaders.setUrl(this.spdyVersion, spdySynStreamFrame, httpRequest.getUri());
            SpdyHeaders.setVersion(this.spdyVersion, spdySynStreamFrame, httpMessage.getProtocolVersion());
        }
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            SpdyHeaders.setStatus(this.spdyVersion, spdySynStreamFrame, httpResponse.getStatus());
            SpdyHeaders.setUrl(this.spdyVersion, spdySynStreamFrame, URL2);
            SpdyHeaders.setVersion(this.spdyVersion, spdySynStreamFrame, httpMessage.getProtocolVersion());
            spdySynStreamFrame.setUnidirectional(true);
        }
        if (this.spdyVersion >= 3) {
            String host = HttpHeaders.getHost(httpMessage);
            httpMessage.removeHeader("Host");
            SpdyHeaders.setHost(spdySynStreamFrame, host);
        }
        if (scheme == null) {
            scheme = "https";
        }
        SpdyHeaders.setScheme(this.spdyVersion, spdySynStreamFrame, scheme);
        for (Map.Entry<String, String> entry : httpMessage.getHeaders()) {
            spdySynStreamFrame.addHeader(entry.getKey(), entry.getValue());
        }
        return spdySynStreamFrame;
    }

    private SpdySynReplyFrame createSynReplyFrame(HttpResponse httpResponse) throws Exception {
        boolean chunked = httpResponse.isChunked();
        int streamId = SpdyHttpHeaders.getStreamId(httpResponse);
        SpdyHttpHeaders.removeStreamId(httpResponse);
        httpResponse.removeHeader("Connection");
        httpResponse.removeHeader("Keep-Alive");
        httpResponse.removeHeader("Proxy-Connection");
        httpResponse.removeHeader("Transfer-Encoding");
        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
        spdySynReplyFrame.setLast(!chunked && !httpResponse.getContent().readable());
        SpdyHeaders.setStatus(this.spdyVersion, spdySynReplyFrame, httpResponse.getStatus());
        SpdyHeaders.setVersion(this.spdyVersion, spdySynReplyFrame, httpResponse.getProtocolVersion());
        for (Map.Entry<String, String> entry : httpResponse.getHeaders()) {
            spdySynReplyFrame.addHeader(entry.getKey(), entry.getValue());
        }
        return spdySynReplyFrame;
    }

    private SpdyDataFrame[] createSpdyDataFrames(int streamId, ChannelBuffer content) {
        int readableBytes = content.readableBytes();
        int count2 = readableBytes / 0xFFFFFF;
        if (readableBytes % 0xFFFFFF > 0) {
            ++count2;
        }
        SpdyDataFrame[] spdyDataFrames = new SpdyDataFrame[count2];
        for (int i = 0; i < count2; ++i) {
            DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
            int dataSize = Math.min(content.readableBytes(), 0xFFFFFF);
            spdyDataFrame.setData(content.readSlice(dataSize));
            spdyDataFrames[i] = spdyDataFrame;
        }
        return spdyDataFrames;
    }

    private static class SpdyFrameWriter
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final MessageEvent e;

        SpdyFrameWriter(ChannelHandlerContext ctx, MessageEvent e2) {
            this.ctx = ctx;
            this.e = e2;
        }

        public void operationComplete(ChannelFuture future2) throws Exception {
            if (future2.isSuccess()) {
                this.ctx.sendDownstream(this.e);
            } else if (future2.isCancelled()) {
                this.e.getFuture().cancel();
            } else {
                this.e.getFuture().setFailure(future2.getCause());
            }
        }
    }
}

