/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.FuncN;
import rx.observers.SerializedSubscriber;
import rx.plugins.RxJavaHooks;

public final class OperatorWithLatestFromMany<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<T> main;
    final Observable<?>[] others;
    final Iterable<Observable<?>> othersIterable;
    final FuncN<R> combiner;

    public OperatorWithLatestFromMany(Observable<T> main2, Observable<?>[] others, Iterable<Observable<?>> othersIterable, FuncN<R> combiner) {
        this.main = main2;
        this.others = others;
        this.othersIterable = othersIterable;
        this.combiner = combiner;
    }

    @Override
    public void call(Subscriber<? super R> t) {
        Observable<?>[] sources;
        SerializedSubscriber<R> serial = new SerializedSubscriber<R>(t);
        int n = 0;
        if (this.others != null) {
            sources = this.others;
            n = sources.length;
        } else {
            sources = new Observable[8];
            for (Observable<?> o : this.othersIterable) {
                if (n == sources.length) {
                    sources = Arrays.copyOf(sources, n + (n >> 2));
                }
                sources[n++] = o;
            }
        }
        WithLatestMainSubscriber parent = new WithLatestMainSubscriber(t, this.combiner, n);
        serial.add(parent);
        for (int i = 0; i < n; ++i) {
            if (serial.isUnsubscribed()) {
                return;
            }
            WithLatestOtherSubscriber inner = new WithLatestOtherSubscriber(parent, i + 1);
            parent.add(inner);
            Observable<?> o = sources[i];
            o.unsafeSubscribe(inner);
        }
        this.main.unsafeSubscribe(parent);
    }

    static final class WithLatestOtherSubscriber
    extends Subscriber<Object> {
        final WithLatestMainSubscriber<?, ?> parent;
        final int index;

        public WithLatestOtherSubscriber(WithLatestMainSubscriber<?, ?> parent, int index2) {
            this.parent = parent;
            this.index = index2;
        }

        @Override
        public void onNext(Object t) {
            this.parent.innerNext(this.index, t);
        }

        @Override
        public void onError(Throwable e2) {
            this.parent.innerError(this.index, e2);
        }

        @Override
        public void onCompleted() {
            this.parent.innerComplete(this.index);
        }
    }

    static final class WithLatestMainSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final FuncN<R> combiner;
        final AtomicReferenceArray<Object> current;
        static final Object EMPTY = new Object();
        final AtomicInteger ready;
        boolean done;

        public WithLatestMainSubscriber(Subscriber<? super R> actual, FuncN<R> combiner, int n) {
            this.actual = actual;
            this.combiner = combiner;
            AtomicReferenceArray<Object> array2 = new AtomicReferenceArray<Object>(n + 1);
            for (int i = 0; i <= n; ++i) {
                array2.lazySet(i, EMPTY);
            }
            this.current = array2;
            this.ready = new AtomicInteger(n);
            this.request(0L);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.ready.get() == 0) {
                R result;
                AtomicReferenceArray<Object> array2 = this.current;
                int n = array2.length();
                array2.lazySet(0, t);
                Object[] copy2 = new Object[array2.length()];
                for (int i = 0; i < n; ++i) {
                    copy2[i] = array2.get(i);
                }
                try {
                    result = this.combiner.call(copy2);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.onError(ex);
                    return;
                }
                this.actual.onNext(result);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.done) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.done = true;
            this.unsubscribe();
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.unsubscribe();
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            super.setProducer(p);
            this.actual.setProducer(p);
        }

        void innerNext(int index2, Object o) {
            Object last2 = this.current.getAndSet(index2, o);
            if (last2 == EMPTY) {
                this.ready.decrementAndGet();
            }
        }

        void innerError(int index2, Throwable e2) {
            this.onError(e2);
        }

        void innerComplete(int index2) {
            if (this.current.get(index2) == EMPTY) {
                this.onCompleted();
            }
        }
    }
}

