/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.DependentConfigListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PrivateViewConfig
extends AbstractConfig {
    private volatile State state;

    private void updateState(Config config) {
        this.state = new State(config);
    }

    public PrivateViewConfig(Config wrappedConfig) {
        this.state = new State(wrappedConfig);
        wrappedConfig.addListener(new ViewConfigListener(this));
    }

    @Override
    public Iterator<String> getKeys() {
        return this.state.data.keySet().iterator();
    }

    @Override
    public boolean containsKey(String key2) {
        return this.state.data.containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.state.data.isEmpty();
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        T t = null;
        for (Map.Entry<String, Object> entry : this.state.data.entrySet()) {
            t = visitor.visitKey(entry.getKey(), entry.getValue());
        }
        return t;
    }

    @Override
    public Object getRawProperty(String key2) {
        return this.state.data.get(key2);
    }

    private static class ViewConfigListener
    extends DependentConfigListener<PrivateViewConfig> {
        private ViewConfigListener(PrivateViewConfig dependentConfig) {
            super(dependentConfig);
        }

        @Override
        public void onSourceConfigAdded(PrivateViewConfig pvc, Config config) {
            pvc.updateState(config);
            pvc.notifyConfigAdded(pvc);
        }

        @Override
        public void onSourceConfigRemoved(PrivateViewConfig pvc, Config config) {
            pvc.updateState(config);
            pvc.notifyConfigRemoved(pvc);
        }

        @Override
        public void onSourceConfigUpdated(PrivateViewConfig pvc, Config config) {
            pvc.updateState(config);
            pvc.notifyConfigUpdated(pvc);
        }

        @Override
        public void onSourceError(Throwable error, PrivateViewConfig pvc, Config config) {
        }
    }

    private static class State {
        final Map<String, Object> data;

        public State(Config config) {
            LinkedHashMap data2 = new LinkedHashMap();
            config.forEachProperty(data2::put);
            this.data = Collections.unmodifiableMap(data2);
        }
    }
}

