/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.readers;

import com.netflix.archaius.config.polling.PollingResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;

public class URLConfigReader
implements Callable<PollingResponse> {
    private final URL[] configUrls;

    public URLConfigReader(String ... urls) {
        this.configUrls = URLConfigReader.createUrls(urls);
    }

    public URLConfigReader(URL ... urls) {
        this.configUrls = urls;
    }

    private static URL[] createUrls(String ... urlStrings) {
        if (urlStrings == null || urlStrings.length == 0) {
            throw new IllegalArgumentException("urlStrings is null or empty");
        }
        URL[] urls = new URL[urlStrings.length];
        try {
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new URL(urlStrings[i]);
            }
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollingResponse call() throws IOException {
        final HashMap<String, String> map2 = new HashMap<String, String>();
        for (URL url : this.configUrls) {
            Properties props = new Properties();
            try (InputStream fin = url.openStream();
                 InputStreamReader reader2 = new InputStreamReader(fin, "UTF-8");){
                props.load(reader2);
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                map2.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return new PollingResponse(){

            @Override
            public Map<String, String> getToAdd() {
                return map2;
            }

            @Override
            public Collection<String> getToRemove() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasData() {
                return true;
            }
        };
    }

    public List<URL> getConfigUrls() {
        return Collections.unmodifiableList(Arrays.asList(this.configUrls));
    }

    public String toString() {
        return "FileConfigurationSource [fileUrls=" + Arrays.toString(this.configUrls) + "]";
    }
}

