/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common;

import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.util.Map;

public class JsonSerializer {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule(new Jdk8Module());
    public static final SimpleFilterProvider DEFAULT_FILTER_PROVIDER = new SimpleFilterProvider();

    public <T> T fromJSON(String json2, Class<T> expectedType) throws IOException {
        return defaultObjectMapper.readerFor(expectedType).readValue(json2);
    }

    public <T> T fromJson(byte[] json2, Class<T> expectedType) throws IOException {
        return defaultObjectMapper.readValue(json2, expectedType);
    }

    public <T> T fromJSON(String json2, TypeReference<T> expectedType) throws IOException {
        return defaultObjectMapper.readerFor(expectedType).readValue(json2);
    }

    public String toJson(Object object) throws IOException {
        return defaultObjectMapper.writeValueAsString(object);
    }

    public byte[] toJsonBytes(Object object) throws IOException {
        return defaultObjectMapper.writeValueAsBytes(object);
    }

    public Map<String, Object> toMap(String json2) throws IOException {
        return defaultObjectMapper.readValue(json2, new TypeReference<Map<String, Object>>(){});
    }

    static {
        DEFAULT_FILTER_PROVIDER.setFailOnUnknownId(false);
    }
}

