/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.clojure.lang;

import io.mantisrx.mql.shaded.clojure.lang.Keyword;
import io.mantisrx.mql.shaded.clojure.lang.RT;
import io.mantisrx.mql.shaded.clojure.lang.Symbol;
import io.mantisrx.mql.shaded.clojure.lang.Var;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Compile {
    private static final String PATH_PROP = "io.mantisrx.mql.shaded.clojure.compile.path";
    private static final String REFLECTION_WARNING_PROP = "io.mantisrx.mql.shaded.clojure.compile.warn-on-reflection";
    private static final String UNCHECKED_MATH_PROP = "io.mantisrx.mql.shaded.clojure.compile.unchecked-math";
    private static final Var compile_path = RT.var("io.mantisrx.mql.shaded.clojure.core", "*compile-path*");
    private static final Var compile = RT.var("io.mantisrx.mql.shaded.clojure.core", "compile");
    private static final Var warn_on_reflection = RT.var("io.mantisrx.mql.shaded.clojure.core", "*warn-on-reflection*");
    private static final Var unchecked_math = RT.var("io.mantisrx.mql.shaded.clojure.core", "*unchecked-math*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        OutputStreamWriter out = (OutputStreamWriter)RT.OUT.deref();
        PrintWriter err = RT.errPrintWriter();
        String path2 = System.getProperty(PATH_PROP);
        int count2 = args.length;
        if (path2 == null) {
            err.println("ERROR: Must set system property clojure.compile.path\nto the location for compiled .class files.\nThis directory must also be on your CLASSPATH.");
            System.exit(1);
        }
        boolean warnOnReflection = System.getProperty(REFLECTION_WARNING_PROP, "false").equals("true");
        String uncheckedMathProp = System.getProperty(UNCHECKED_MATH_PROP);
        Comparable<Boolean> uncheckedMath = Boolean.FALSE;
        if ("true".equals(uncheckedMathProp)) {
            uncheckedMath = Boolean.TRUE;
        } else if ("warn-on-boxed".equals(uncheckedMathProp)) {
            uncheckedMath = Keyword.intern("warn-on-boxed");
        }
        try {
            Var.pushThreadBindings(RT.map(compile_path, path2, warn_on_reflection, warnOnReflection, unchecked_math, uncheckedMath));
            for (String lib : args) {
                out.write("Compiling " + lib + " to " + path2 + "\n");
                out.flush();
                compile.invoke(Symbol.intern(lib));
            }
        }
        finally {
            Var.popThreadBindings();
            try {
                out.flush();
            }
            catch (IOException e2) {
                e2.printStackTrace(err);
            }
        }
    }
}

