/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.clojure.lang;

import io.mantisrx.mql.shaded.clojure.lang.APersistentSet;
import io.mantisrx.mql.shaded.clojure.lang.ATransientSet;
import io.mantisrx.mql.shaded.clojure.lang.IEditableCollection;
import io.mantisrx.mql.shaded.clojure.lang.IObj;
import io.mantisrx.mql.shaded.clojure.lang.IPersistentCollection;
import io.mantisrx.mql.shaded.clojure.lang.IPersistentMap;
import io.mantisrx.mql.shaded.clojure.lang.IPersistentSet;
import io.mantisrx.mql.shaded.clojure.lang.ISeq;
import io.mantisrx.mql.shaded.clojure.lang.ITransientCollection;
import io.mantisrx.mql.shaded.clojure.lang.ITransientMap;
import io.mantisrx.mql.shaded.clojure.lang.ITransientSet;
import io.mantisrx.mql.shaded.clojure.lang.PersistentHashMap;
import java.util.List;

public class PersistentHashSet
extends APersistentSet
implements IObj,
IEditableCollection {
    public static final PersistentHashSet EMPTY = new PersistentHashSet(null, PersistentHashMap.EMPTY);
    final IPersistentMap _meta;

    public static PersistentHashSet create(Object ... init) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        for (int i = 0; i < init.length; ++i) {
            ret = (ITransientSet)ret.conj(init[i]);
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet create(List init) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        for (Object key2 : init) {
            ret = (ITransientSet)ret.conj(key2);
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet create(ISeq items) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        while (items != null) {
            ret = (ITransientSet)ret.conj(items.first());
            items = items.next();
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet createWithCheck(Object ... init) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        for (int i = 0; i < init.length; ++i) {
            if ((ret = (ITransientSet)ret.conj(init[i])).count() == i + 1) continue;
            throw new IllegalArgumentException("Duplicate key: " + init[i]);
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet createWithCheck(List init) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        int i = 0;
        for (Object key2 : init) {
            if ((ret = (ITransientSet)ret.conj(key2)).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + key2);
            }
            ++i;
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet createWithCheck(ISeq items) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        int i = 0;
        while (items != null) {
            if ((ret = (ITransientSet)ret.conj(items.first())).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + items.first());
            }
            items = items.next();
            ++i;
        }
        return (PersistentHashSet)ret.persistent();
    }

    PersistentHashSet(IPersistentMap meta, IPersistentMap impl) {
        super(impl);
        this._meta = meta;
    }

    @Override
    public IPersistentSet disjoin(Object key2) {
        if (this.contains(key2)) {
            return new PersistentHashSet(this.meta(), this.impl.without(key2));
        }
        return this;
    }

    @Override
    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentHashSet(this.meta(), this.impl.assoc(o, o));
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentHashSet withMeta(IPersistentMap meta) {
        return new PersistentHashSet(meta, this.impl);
    }

    @Override
    public ITransientCollection asTransient() {
        return new TransientHashSet(((PersistentHashMap)this.impl).asTransient());
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    static final class TransientHashSet
    extends ATransientSet {
        TransientHashSet(ITransientMap impl) {
            super(impl);
        }

        @Override
        public IPersistentCollection persistent() {
            return new PersistentHashSet(null, this.impl.persistent());
        }
    }
}

