/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LocalDateDeserializer
extends JSR310DateTimeDeserializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final LocalDateDeserializer INSTANCE = new LocalDateDeserializer();

    protected LocalDateDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateDeserializer(DateTimeFormatter dtf) {
        super(LocalDate.class, dtf);
    }

    public LocalDateDeserializer(LocalDateDeserializer base, DateTimeFormatter dtf) {
        super(base, dtf);
    }

    protected LocalDateDeserializer(LocalDateDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected LocalDateDeserializer(LocalDateDeserializer base, JsonFormat.Shape shape) {
        super(base, shape);
    }

    protected LocalDateDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new LocalDateDeserializer(this, dtf);
    }

    @Override
    protected LocalDateDeserializer withLeniency(Boolean leniency) {
        return new LocalDateDeserializer(this, leniency);
    }

    protected LocalDateDeserializer withShape(JsonFormat.Shape shape) {
        return new LocalDateDeserializer(this, shape);
    }

    @Override
    public LocalDate deserialize(JsonParser parser2, DeserializationContext context) throws IOException {
        if (parser2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(parser2, context, parser2.getText());
        }
        if (parser2.isExpectedStartObjectToken()) {
            return this._fromString(parser2, context, context.extractScalarFromObject(parser2, this, this.handledType()));
        }
        if (parser2.isExpectedStartArrayToken()) {
            JsonToken t = parser2.nextToken();
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if (context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && (t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT)) {
                LocalDate parsed = this.deserialize(parser2, context);
                if (parser2.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser2, context);
                }
                return parsed;
            }
            if (t == JsonToken.VALUE_NUMBER_INT) {
                int year = parser2.getIntValue();
                int month = parser2.nextIntValue(-1);
                int day = parser2.nextIntValue(-1);
                if (parser2.nextToken() != JsonToken.END_ARRAY) {
                    throw context.wrongTokenException(parser2, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                }
                return LocalDate.of(year, month, day);
            }
            context.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{t});
        }
        if (parser2.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDate)parser2.getEmbeddedObject();
        }
        if (parser2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT || this.isLenient()) {
                return LocalDate.ofEpochDay(parser2.getLongValue());
            }
            return (LocalDate)this._failForNotLenient(parser2, context, JsonToken.VALUE_STRING);
        }
        return (LocalDate)this._handleUnexpectedToken(context, parser2, "Expected array or string.", new Object[0]);
    }

    protected LocalDate _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (LocalDate)this._fromEmptyString(p, ctxt, string2);
        }
        try {
            DateTimeFormatter format2 = this._formatter;
            if (format2 == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T') {
                if (string2.endsWith("Z")) {
                    return LocalDateTime.ofInstant(Instant.parse(string2), ZoneOffset.UTC).toLocalDate();
                }
                return LocalDate.parse(string2, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            return LocalDate.parse(string2, format2);
        }
        catch (DateTimeException e2) {
            return (LocalDate)this._handleDateTimeException(ctxt, e2, string2);
        }
    }
}

