/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();

    protected LocalDateTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateTimeDeserializer(DateTimeFormatter formatter2) {
        super(LocalDateTime.class, formatter2);
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected LocalDateTimeDeserializer withDateFormat(DateTimeFormatter formatter2) {
        return new LocalDateTimeDeserializer(formatter2);
    }

    @Override
    protected LocalDateTimeDeserializer withLeniency(Boolean leniency) {
        return new LocalDateTimeDeserializer(this, leniency);
    }

    protected LocalDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public LocalDateTime deserialize(JsonParser parser2, DeserializationContext context) throws IOException {
        if (parser2.hasTokenId(6)) {
            return this._fromString(parser2, context, parser2.getText());
        }
        if (parser2.isExpectedStartObjectToken()) {
            return this._fromString(parser2, context, context.extractScalarFromObject(parser2, this, this.handledType()));
        }
        if (parser2.isExpectedStartArrayToken()) {
            JsonToken t = parser2.nextToken();
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                LocalDateTime parsed = this.deserialize(parser2, context);
                if (parser2.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser2, context);
                }
                return parsed;
            }
            if (t == JsonToken.VALUE_NUMBER_INT) {
                LocalDateTime result;
                int year = parser2.getIntValue();
                int month = parser2.nextIntValue(-1);
                int day = parser2.nextIntValue(-1);
                int hour = parser2.nextIntValue(-1);
                int minute = parser2.nextIntValue(-1);
                t = parser2.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    result = LocalDateTime.of(year, month, day, hour, minute);
                } else {
                    int second = parser2.getIntValue();
                    t = parser2.nextToken();
                    if (t == JsonToken.END_ARRAY) {
                        result = LocalDateTime.of(year, month, day, hour, minute, second);
                    } else {
                        int partialSecond = parser2.getIntValue();
                        if (partialSecond < 1000 && !context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            partialSecond *= 1000000;
                        }
                        if (parser2.nextToken() != JsonToken.END_ARRAY) {
                            throw context.wrongTokenException(parser2, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        result = LocalDateTime.of(year, month, day, hour, minute, second, partialSecond);
                    }
                }
                return result;
            }
            context.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{t});
        }
        if (parser2.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDateTime)parser2.getEmbeddedObject();
        }
        if (parser2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(parser2, context);
        }
        return (LocalDateTime)this._handleUnexpectedToken(context, parser2, "Expected array or string.", new Object[0]);
    }

    protected LocalDateTime _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (LocalDateTime)this._fromEmptyString(p, ctxt, string2);
        }
        try {
            if (this._formatter == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T' && string2.endsWith("Z")) {
                if (this.isLenient()) {
                    return LocalDateTime.parse(string2.substring(0, string2.length() - 1), this._formatter);
                }
                JavaType t = this.getValueType(ctxt);
                return (LocalDateTime)ctxt.handleWeirdStringValue(t.getRawClass(), string2, "Should not contain offset when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDateTime.parse(string2, this._formatter);
        }
        catch (DateTimeException e2) {
            return (LocalDateTime)this._handleDateTimeException(ctxt, e2, string2);
        }
    }
}

