/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.core.StreamReadCapability;
import io.mantisrx.shaded.com.fasterxml.jackson.core.io.NumberInput;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;

public class YearDeserializer
extends JSR310DateTimeDeserializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearDeserializer INSTANCE = new YearDeserializer();

    public YearDeserializer() {
        this((DateTimeFormatter)null);
    }

    public YearDeserializer(DateTimeFormatter formatter2) {
        super(Year.class, formatter2);
    }

    protected YearDeserializer(YearDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected YearDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new YearDeserializer(dtf);
    }

    @Override
    protected YearDeserializer withLeniency(Boolean leniency) {
        return new YearDeserializer(this, leniency);
    }

    protected YearDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public Year deserialize(JsonParser parser2, DeserializationContext context) throws IOException {
        JsonToken t = parser2.currentToken();
        if (t == JsonToken.VALUE_STRING) {
            return this._fromString(parser2, context, parser2.getText());
        }
        if (t == JsonToken.START_OBJECT) {
            return this._fromString(parser2, context, context.extractScalarFromObject(parser2, this, this.handledType()));
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return this._fromNumber(context, parser2.getIntValue());
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (Year)parser2.getEmbeddedObject();
        }
        if (parser2.hasToken(JsonToken.START_ARRAY)) {
            return (Year)this._deserializeFromArray(parser2, context);
        }
        return (Year)this._handleUnexpectedToken(context, parser2, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT);
    }

    protected Year _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (Year)this._fromEmptyString(p, ctxt, string2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(string2)) {
            return this._fromNumber(ctxt, NumberInput.parseInt(string2));
        }
        try {
            if (this._formatter == null) {
                return Year.parse(string2);
            }
            return Year.parse(string2, this._formatter);
        }
        catch (DateTimeException e2) {
            return (Year)this._handleDateTimeException(ctxt, e2, string2);
        }
    }

    protected Year _fromNumber(DeserializationContext ctxt, int value) {
        return Year.of(value);
    }
}

