/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.buffer;

import io.mantisrx.shaded.io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBufAllocator;
import io.mantisrx.shaded.io.netty.buffer.PoolChunk;
import io.mantisrx.shaded.io.netty.buffer.PoolThreadCache;
import io.mantisrx.shaded.io.netty.buffer.PooledDuplicatedByteBuf;
import io.mantisrx.shaded.io.netty.buffer.PooledSlicedByteBuf;
import io.mantisrx.shaded.io.netty.util.Recycler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler.Handle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    protected PooledByteBuf(Recycler.Handle<? extends PooledByteBuf<T>> recyclerHandle, int maxCapacity) {
        super(maxCapacity);
        this.recyclerHandle = recyclerHandle;
    }

    void init(PoolChunk<T> chunk2, ByteBuffer nioBuffer, long handle, int offset, int length, int maxLength, PoolThreadCache cache2) {
        this.init0(chunk2, nioBuffer, handle, offset, length, maxLength, cache2);
    }

    void initUnpooled(PoolChunk<T> chunk2, int length) {
        this.init0(chunk2, null, 0L, chunk2.offset, length, length, null);
    }

    private void init0(PoolChunk<T> chunk2, ByteBuffer nioBuffer, long handle, int offset, int length, int maxLength, PoolThreadCache cache2) {
        assert (handle >= 0L);
        assert (chunk2 != null);
        this.chunk = chunk2;
        this.memory = chunk2.memory;
        this.tmpNioBuf = nioBuffer;
        this.allocator = chunk2.arena.parent;
        this.cache = cache2;
        this.handle = handle;
        this.offset = offset;
        this.length = length;
        this.maxLength = maxLength;
    }

    final void reuse(int maxCapacity) {
        this.maxCapacity(maxCapacity);
        this.setRefCnt(1);
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final ByteBuf capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        if (this.chunk.unpooled) {
            if (newCapacity == this.length) {
                return this;
            }
        } else if (newCapacity > this.length) {
            if (newCapacity <= this.maxLength) {
                this.length = newCapacity;
                return this;
            }
        } else {
            if (newCapacity >= this.length) return this;
            if (newCapacity > this.maxLength >>> 1) {
                if (this.maxLength <= 512) {
                    if (newCapacity > this.maxLength - 16) {
                        this.length = newCapacity;
                        this.setIndex(Math.min(this.readerIndex(), newCapacity), Math.min(this.writerIndex(), newCapacity));
                        return this;
                    }
                } else {
                    this.length = newCapacity;
                    this.setIndex(Math.min(this.readerIndex(), newCapacity), Math.min(this.writerIndex(), newCapacity));
                    return this;
                }
            }
        }
        this.chunk.arena.reallocate(this, newCapacity, true);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int index2 = this.readerIndex();
        return this.retainedSlice(index2, this.writerIndex() - index2);
    }

    @Override
    public final ByteBuf retainedSlice(int index2, int length) {
        return PooledSlicedByteBuf.newInstance(this, this, index2, length);
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.newInternalNioBuffer(this.memory);
        }
        return tmpNioBuf;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long handle = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.chunk.arena.free(this.chunk, this.tmpNioBuf, handle, this.maxLength, this.cache);
            this.tmpNioBuf = null;
            this.chunk = null;
            this.recycle();
        }
    }

    private void recycle() {
        this.recyclerHandle.recycle(this);
    }

    protected final int idx(int index2) {
        return this.offset + index2;
    }
}

