/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.buffer;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBufUtil;
import io.mantisrx.shaded.io.netty.buffer.PooledByteBuf;
import io.mantisrx.shaded.io.netty.util.Recycler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledDirectByteBuf> RECYCLER = new Recycler<PooledDirectByteBuf>(){

        @Override
        protected PooledDirectByteBuf newObject(Recycler.Handle<PooledDirectByteBuf> handle) {
            return new PooledDirectByteBuf(handle, 0);
        }
    };

    static PooledDirectByteBuf newInstance(int maxCapacity) {
        PooledDirectByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledDirectByteBuf(Recycler.Handle<PooledDirectByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int index2) {
        return ((ByteBuffer)this.memory).get(this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return ((ByteBuffer)this.memory).getShort(this.idx(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return ByteBufUtil.swapShort(this._getShort(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        index2 = this.idx(index2);
        return (((ByteBuffer)this.memory).get(index2) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(index2 + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(index2 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        index2 = this.idx(index2);
        return ((ByteBuffer)this.memory).get(index2) & 0xFF | (((ByteBuffer)this.memory).get(index2 + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get(index2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int index2) {
        return ((ByteBuffer)this.memory).getInt(this.idx(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return ByteBufUtil.swapInt(this._getInt(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return ((ByteBuffer)this.memory).getLong(this.idx(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return ByteBufUtil.swapLong(this._getLong(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length)) {
                int bbLen = bb.remaining();
                this.getBytes(index2, bb);
                index2 += bbLen;
            }
        } else {
            dst.setBytes(dstIndex, this, index2, length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.getBytes(index2, dst, dstIndex, length, false);
        return this;
    }

    private void getBytes(int index2, byte[] dst, int dstIndex, int length, boolean internal) {
        this.checkDstIndex(index2, length, dstIndex, dst.length);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length);
        tmpBuf.get(dst, dstIndex, length);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst, dstIndex, length, true);
        this.readerIndex += length;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.getBytes(index2, dst, false);
        return this;
    }

    private void getBytes(int index2, ByteBuffer dst, boolean internal) {
        this.checkIndex(index2, dst.remaining());
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + dst.remaining());
        dst.put(tmpBuf);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst, true);
        this.readerIndex += length;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.getBytes(index2, out, length, false);
        return this;
    }

    private void getBytes(int index2, OutputStream out, int length, boolean internal) throws IOException {
        this.checkIndex(index2, length);
        if (length == 0) {
            return;
        }
        ByteBufUtil.readBytes(this.alloc(), internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate(), this.idx(index2), length, out);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, out, length, true);
        this.readerIndex += length;
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return this.getBytes(index2, out, length, false);
    }

    private int getBytes(int index2, GatheringByteChannel out, int length, boolean internal) throws IOException {
        this.checkIndex(index2, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length);
        return out.write(tmpBuf);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length) throws IOException {
        return this.getBytes(index2, out, position, length, false);
    }

    private int getBytes(int index2, FileChannel out, long position, int length, boolean internal) throws IOException {
        this.checkIndex(index2, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length);
        return out.write(tmpBuf, position);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(this.readerIndex, out, length, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(this.readerIndex, out, position, length, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    protected void _setByte(int index2, int value) {
        ((ByteBuffer)this.memory).put(this.idx(index2), (byte)value);
    }

    @Override
    protected void _setShort(int index2, int value) {
        ((ByteBuffer)this.memory).putShort(this.idx(index2), (short)value);
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        this._setShort(index2, ByteBufUtil.swapShort((short)value));
    }

    @Override
    protected void _setMedium(int index2, int value) {
        index2 = this.idx(index2);
        ((ByteBuffer)this.memory).put(index2, (byte)(value >>> 16));
        ((ByteBuffer)this.memory).put(index2 + 1, (byte)(value >>> 8));
        ((ByteBuffer)this.memory).put(index2 + 2, (byte)value);
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        index2 = this.idx(index2);
        ((ByteBuffer)this.memory).put(index2, (byte)value);
        ((ByteBuffer)this.memory).put(index2 + 1, (byte)(value >>> 8));
        ((ByteBuffer)this.memory).put(index2 + 2, (byte)(value >>> 16));
    }

    @Override
    protected void _setInt(int index2, int value) {
        ((ByteBuffer)this.memory).putInt(this.idx(index2), value);
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        this._setInt(index2, ByteBufUtil.swapInt(value));
    }

    @Override
    protected void _setLong(int index2, long value) {
        ((ByteBuffer)this.memory).putLong(this.idx(index2), value);
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        this._setLong(index2, ByteBufUtil.swapLong(value));
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index2, length, srcIndex, src.capacity());
        if (src.hasArray()) {
            this.setBytes(index2, src.array(), src.arrayOffset() + srcIndex, length);
        } else if (src.nioBufferCount() > 0) {
            for (ByteBuffer bb : src.nioBuffers(srcIndex, length)) {
                int bbLen = bb.remaining();
                this.setBytes(index2, bb);
                index2 += bbLen;
            }
        } else {
            src.getBytes(srcIndex, this, index2, length);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.checkSrcIndex(index2, length, srcIndex, src.length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length);
        tmpBuf.put(src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.checkIndex(index2, src.remaining());
        ByteBuffer tmpBuf = this.internalNioBuffer();
        if (src == tmpBuf) {
            src = src.duplicate();
        }
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + src.remaining());
        tmpBuf.put(src);
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        this.checkIndex(index2, length);
        byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
        int readBytes = in.read(tmp, 0, length);
        if (readBytes <= 0) {
            return readBytes;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(this.idx(index2));
        tmpBuf.put(tmp, 0, readBytes);
        return readBytes;
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index2, length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length);
        try {
            return in.read(tmpBuf);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length) throws IOException {
        this.checkIndex(index2, length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index2 = this.idx(index2);
        tmpBuf.clear().position(index2).limit(index2 + length);
        try {
            return in.read(tmpBuf, position);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex(index2, length);
        ByteBuf copy2 = this.alloc().directBuffer(length, this.maxCapacity());
        copy2.writeBytes(this, index2, length);
        return copy2;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        index2 = this.idx(index2);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(index2).limit(index2 + length)).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        return new ByteBuffer[]{this.nioBuffer(index2, length)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        index2 = this.idx(index2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

