/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.channel;

import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import io.mantisrx.shaded.io.netty.channel.PendingBytesTracker;
import io.mantisrx.shaded.io.netty.channel.VoidChannelPromise;
import io.mantisrx.shaded.io.netty.util.Recycler;
import io.mantisrx.shaded.io.netty.util.ReferenceCountUtil;
import io.mantisrx.shaded.io.netty.util.concurrent.PromiseCombiner;
import io.mantisrx.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLogger;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("io.mantisrx.shaded.io.netty.transport.pendingWriteSizeOverhead", 64);
    private final ChannelHandlerContext ctx;
    private final PendingBytesTracker tracker;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext ctx) {
        this.tracker = PendingBytesTracker.newTracker(ctx.channel());
        this.ctx = ctx;
    }

    public boolean isEmpty() {
        assert (this.ctx.executor().inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.ctx.executor().inEventLoop());
        return this.size;
    }

    public long bytes() {
        assert (this.ctx.executor().inEventLoop());
        return this.bytes;
    }

    private int size(Object msg) {
        int messageSize = this.tracker.size(msg);
        if (messageSize < 0) {
            messageSize = 0;
        }
        return messageSize + PENDING_WRITE_OVERHEAD;
    }

    public void add(Object msg, ChannelPromise promise2) {
        assert (this.ctx.executor().inEventLoop());
        if (msg == null) {
            throw new NullPointerException("msg");
        }
        if (promise2 == null) {
            throw new NullPointerException("promise");
        }
        int messageSize = this.size(msg);
        PendingWrite write2 = PendingWrite.newInstance(msg, messageSize, promise2);
        PendingWrite currentTail = this.tail;
        if (currentTail == null) {
            this.tail = this.head = write2;
        } else {
            currentTail.next = write2;
            this.tail = write2;
        }
        ++this.size;
        this.bytes += (long)messageSize;
        this.tracker.incrementPendingOutboundBytes(write2.size);
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.ctx.executor().inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise p = this.ctx.newPromise();
        PromiseCombiner combiner = new PromiseCombiner(this.ctx.executor());
        try {
            PendingWrite write2 = this.head;
            while (write2 != null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (write2 != null) {
                    PendingWrite next2 = write2.next;
                    Object msg = write2.msg;
                    ChannelPromise promise2 = write2.promise;
                    this.recycle(write2, false);
                    if (!(promise2 instanceof VoidChannelPromise)) {
                        combiner.add(promise2);
                    }
                    this.ctx.write(msg, promise2);
                    write2 = next2;
                }
                write2 = this.head;
            }
            combiner.finish(p);
        }
        catch (Throwable cause) {
            p.setFailure(cause);
        }
        this.assertEmpty();
        return p;
    }

    public void removeAndFailAll(Throwable cause) {
        assert (this.ctx.executor().inEventLoop());
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite write2 = this.head;
        while (write2 != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (write2 != null) {
                PendingWrite next2 = write2.next;
                ReferenceCountUtil.safeRelease(write2.msg);
                ChannelPromise promise2 = write2.promise;
                this.recycle(write2, false);
                PendingWriteQueue.safeFail(promise2, cause);
                write2 = next2;
            }
            write2 = this.head;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable cause) {
        assert (this.ctx.executor().inEventLoop());
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(write2.msg);
        ChannelPromise promise2 = write2.promise;
        PendingWriteQueue.safeFail(promise2, cause);
        this.recycle(write2, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        Object msg = write2.msg;
        ChannelPromise promise2 = write2.promise;
        this.recycle(write2, true);
        return this.ctx.write(msg, promise2);
    }

    public ChannelPromise remove() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        ChannelPromise promise2 = write2.promise;
        ReferenceCountUtil.safeRelease(write2.msg);
        this.recycle(write2, true);
        return promise2;
    }

    public Object current() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        return write2.msg;
    }

    private void recycle(PendingWrite write2, boolean update2) {
        PendingWrite next2 = write2.next;
        long writeSize = write2.size;
        if (update2) {
            if (next2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = next2;
                --this.size;
                this.bytes -= writeSize;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        write2.recycle();
        this.tracker.decrementPendingOutboundBytes(writeSize);
    }

    private static void safeFail(ChannelPromise promise2, Throwable cause) {
        if (!(promise2 instanceof VoidChannelPromise) && !promise2.tryFailure(cause)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise2, (Object)cause);
        }
    }

    static final class PendingWrite {
        private static final Recycler<PendingWrite> RECYCLER = new Recycler<PendingWrite>(){

            @Override
            protected PendingWrite newObject(Recycler.Handle<PendingWrite> handle) {
                return new PendingWrite(handle);
            }
        };
        private final Recycler.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(Recycler.Handle<PendingWrite> handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object msg, int size, ChannelPromise promise2) {
            PendingWrite write2 = RECYCLER.get();
            write2.size = size;
            write2.msg = msg;
            write2.promise = promise2;
            return write2;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

