/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.channel.socket.nio;

import io.mantisrx.shaded.io.netty.channel.ChannelException;
import io.mantisrx.shaded.io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Set;

public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    private NioChannelOption(SocketOption<T> option) {
        super(option.name());
        this.option = option;
    }

    public static <T> ChannelOption<T> of(SocketOption<T> option) {
        return new NioChannelOption<T>(option);
    }

    static <T> boolean setOption(Channel jdkChannel, NioChannelOption<T> option, T value) {
        NetworkChannel channel = (NetworkChannel)jdkChannel;
        if (!channel.supportedOptions().contains(option.option)) {
            return false;
        }
        if (channel instanceof ServerSocketChannel && option.option == StandardSocketOptions.IP_TOS) {
            return false;
        }
        try {
            channel.setOption(option.option, value);
            return true;
        }
        catch (IOException e2) {
            throw new ChannelException(e2);
        }
    }

    static <T> T getOption(Channel jdkChannel, NioChannelOption<T> option) {
        NetworkChannel channel = (NetworkChannel)jdkChannel;
        if (!channel.supportedOptions().contains(option.option)) {
            return null;
        }
        if (channel instanceof ServerSocketChannel && option.option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            return channel.getOption(option.option);
        }
        catch (IOException e2) {
            throw new ChannelException(e2);
        }
    }

    static ChannelOption[] getOptions(Channel jdkChannel) {
        NetworkChannel channel = (NetworkChannel)jdkChannel;
        Set<SocketOption<?>> supportedOpts = channel.supportedOptions();
        if (channel instanceof ServerSocketChannel) {
            ArrayList extraOpts = new ArrayList(supportedOpts.size());
            for (SocketOption<?> opt2 : supportedOpts) {
                if (opt2 == StandardSocketOptions.IP_TOS) continue;
                extraOpts.add(new NioChannelOption(opt2));
            }
            return extraOpts.toArray(new ChannelOption[0]);
        }
        ChannelOption[] extraOpts = new ChannelOption[supportedOpts.size()];
        int i = 0;
        for (SocketOption<?> opt3 : supportedOpts) {
            extraOpts[i++] = new NioChannelOption(opt3);
        }
        return extraOpts;
    }
}

