/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.Unpooled;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import io.mantisrx.shaded.io.netty.handler.codec.EncoderException;
import io.mantisrx.shaded.io.netty.util.ReferenceCountUtil;
import io.mantisrx.shaded.io.netty.util.ReferenceCounted;
import io.mantisrx.shaded.io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    protected MessageToByteEncoder() {
        this(true);
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this(outboundMessageType, true);
    }

    protected MessageToByteEncoder(boolean preferDirect) {
        this.matcher = TypeParameterMatcher.find(this, MessageToByteEncoder.class, "I");
        this.preferDirect = preferDirect;
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType, boolean preferDirect) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
        this.preferDirect = preferDirect;
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise2) throws Exception {
        block14: {
            ReferenceCounted buf = null;
            try {
                if (this.acceptOutboundMessage(msg)) {
                    Object cast2 = msg;
                    buf = this.allocateBuffer(ctx, cast2, this.preferDirect);
                    try {
                        this.encode(ctx, cast2, (ByteBuf)buf);
                    }
                    finally {
                        ReferenceCountUtil.release(cast2);
                    }
                    if (((ByteBuf)buf).isReadable()) {
                        ctx.write(buf, promise2);
                    } else {
                        buf.release();
                        ctx.write(Unpooled.EMPTY_BUFFER, promise2);
                    }
                    buf = null;
                    break block14;
                }
                ctx.write(msg, promise2);
            }
            catch (EncoderException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new EncoderException(e3);
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
            }
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, I msg, boolean preferDirect) throws Exception {
        if (preferDirect) {
            return ctx.alloc().ioBuffer();
        }
        return ctx.alloc().heapBuffer();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;

    protected boolean isPreferDirect() {
        return this.preferDirect;
    }
}

