/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec.dns;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.channel.AddressedEnvelope;
import io.mantisrx.shaded.io.netty.channel.ChannelHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.socket.DatagramPacket;
import io.mantisrx.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsQuery;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsQuestion;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecordEncoder;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsSection;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramDnsQueryEncoder
extends MessageToMessageEncoder<AddressedEnvelope<DnsQuery, InetSocketAddress>> {
    private final DnsRecordEncoder recordEncoder;

    public DatagramDnsQueryEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public DatagramDnsQueryEncoder(DnsRecordEncoder recordEncoder) {
        this.recordEncoder = ObjectUtil.checkNotNull(recordEncoder, "recordEncoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<DnsQuery, InetSocketAddress> in, List<Object> out) throws Exception {
        InetSocketAddress recipient = in.recipient();
        DnsQuery query2 = in.content();
        ByteBuf buf = this.allocateBuffer(ctx, in);
        boolean success2 = false;
        try {
            DatagramDnsQueryEncoder.encodeHeader(query2, buf);
            this.encodeQuestions(query2, buf);
            this.encodeRecords(query2, DnsSection.ADDITIONAL, buf);
            success2 = true;
        }
        finally {
            if (!success2) {
                buf.release();
            }
        }
        out.add(new DatagramPacket(buf, recipient, null));
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, AddressedEnvelope<DnsQuery, InetSocketAddress> msg) throws Exception {
        return ctx.alloc().ioBuffer(1024);
    }

    private static void encodeHeader(DnsQuery query2, ByteBuf buf) {
        buf.writeShort(query2.id());
        int flags = 0;
        flags |= (query2.opCode().byteValue() & 0xFF) << 14;
        if (query2.isRecursionDesired()) {
            flags |= 0x100;
        }
        buf.writeShort(flags);
        buf.writeShort(query2.count(DnsSection.QUESTION));
        buf.writeShort(0);
        buf.writeShort(0);
        buf.writeShort(query2.count(DnsSection.ADDITIONAL));
    }

    private void encodeQuestions(DnsQuery query2, ByteBuf buf) throws Exception {
        int count2 = query2.count(DnsSection.QUESTION);
        for (int i = 0; i < count2; ++i) {
            this.recordEncoder.encodeQuestion((DnsQuestion)query2.recordAt(DnsSection.QUESTION, i), buf);
        }
    }

    private void encodeRecords(DnsQuery query2, DnsSection section, ByteBuf buf) throws Exception {
        int count2 = query2.count(section);
        for (int i = 0; i < count2; ++i) {
            this.recordEncoder.encodeRecord((DnsRecord)query2.recordAt(section, i), buf);
        }
    }
}

