/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec.http2;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import io.mantisrx.shaded.io.netty.handler.codec.http2.Http2Flags;
import io.mantisrx.shaded.io.netty.handler.codec.http2.Http2FrameLogger;
import io.mantisrx.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import io.mantisrx.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.mantisrx.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;

public class Http2OutboundFrameLogger
implements Http2FrameWriter {
    private final Http2FrameWriter writer;
    private final Http2FrameLogger logger;

    public Http2OutboundFrameLogger(Http2FrameWriter writer2, Http2FrameLogger logger) {
        this.writer = ObjectUtil.checkNotNull(writer2, "writer");
        this.logger = ObjectUtil.checkNotNull(logger, "logger");
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data2, int padding, boolean endStream, ChannelPromise promise2) {
        this.logger.logData(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, data2, padding, endStream);
        return this.writer.writeData(ctx, streamId, data2, padding, endStream, promise2);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise2) {
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, headers, padding, endStream);
        return this.writer.writeHeaders(ctx, streamId, headers, padding, endStream, promise2);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise2) {
        this.logger.logHeaders(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
        return this.writer.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream, promise2);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise2) {
        this.logger.logPriority(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, streamDependency, weight, exclusive);
        return this.writer.writePriority(ctx, streamId, streamDependency, weight, exclusive, promise2);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise2) {
        this.logger.logRstStream(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, errorCode);
        return this.writer.writeRstStream(ctx, streamId, errorCode, promise2);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise2) {
        this.logger.logSettings(Http2FrameLogger.Direction.OUTBOUND, ctx, settings);
        return this.writer.writeSettings(ctx, settings, promise2);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise2) {
        this.logger.logSettingsAck(Http2FrameLogger.Direction.OUTBOUND, ctx);
        return this.writer.writeSettingsAck(ctx, promise2);
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data2, ChannelPromise promise2) {
        if (ack) {
            this.logger.logPingAck(Http2FrameLogger.Direction.OUTBOUND, ctx, data2);
        } else {
            this.logger.logPing(Http2FrameLogger.Direction.OUTBOUND, ctx, data2);
        }
        return this.writer.writePing(ctx, ack, data2, promise2);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise2) {
        this.logger.logPushPromise(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, promisedStreamId, headers, padding);
        return this.writer.writePushPromise(ctx, streamId, promisedStreamId, headers, padding, promise2);
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise2) {
        this.logger.logGoAway(Http2FrameLogger.Direction.OUTBOUND, ctx, lastStreamId, errorCode, debugData);
        return this.writer.writeGoAway(ctx, lastStreamId, errorCode, debugData, promise2);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise2) {
        this.logger.logWindowsUpdate(Http2FrameLogger.Direction.OUTBOUND, ctx, streamId, windowSizeIncrement);
        return this.writer.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise2);
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise2) {
        this.logger.logUnknownFrame(Http2FrameLogger.Direction.OUTBOUND, ctx, frameType, streamId, flags, payload);
        return this.writer.writeFrame(ctx, frameType, streamId, flags, payload, promise2);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.writer.configuration();
    }
}

