/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec.http2;

import io.mantisrx.shaded.io.netty.channel.Channel;
import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.io.netty.channel.ChannelHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.ChannelOption;
import io.mantisrx.shaded.io.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.mantisrx.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.mantisrx.shaded.io.netty.util.AbstractConstant;
import io.mantisrx.shaded.io.netty.util.AttributeKey;
import io.mantisrx.shaded.io.netty.util.concurrent.EventExecutor;
import io.mantisrx.shaded.io.netty.util.concurrent.Future;
import io.mantisrx.shaded.io.netty.util.concurrent.Promise;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import io.mantisrx.shaded.io.netty.util.internal.StringUtil;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLogger;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Http2StreamChannelBootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrap.class);
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new LinkedHashMap();
    private final Channel channel;
    private volatile ChannelHandler handler;

    public Http2StreamChannelBootstrap(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Http2StreamChannelBootstrap option(ChannelOption<T> option, T value) {
        if (option == null) {
            throw new NullPointerException("option");
        }
        if (value == null) {
            Map<ChannelOption<?>, Object> map2 = this.options;
            synchronized (map2) {
                this.options.remove(option);
            }
        }
        Map<ChannelOption<?>, Object> map3 = this.options;
        synchronized (map3) {
            this.options.put(option, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Http2StreamChannelBootstrap attr(AttributeKey<T> key2, T value) {
        if (key2 == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            Map<AttributeKey<?>, Object> map2 = this.attrs;
            synchronized (map2) {
                this.attrs.remove(key2);
            }
        }
        Map<AttributeKey<?>, Object> map3 = this.attrs;
        synchronized (map3) {
            this.attrs.put(key2, value);
        }
        return this;
    }

    public Http2StreamChannelBootstrap handler(ChannelHandler handler) {
        this.handler = ObjectUtil.checkNotNull(handler, "handler");
        return this;
    }

    public Future<Http2StreamChannel> open() {
        return this.open(this.channel.eventLoop().newPromise());
    }

    public Future<Http2StreamChannel> open(final Promise<Http2StreamChannel> promise2) {
        final ChannelHandlerContext ctx = this.channel.pipeline().context(Http2MultiplexCodec.class);
        if (ctx == null) {
            if (this.channel.isActive()) {
                promise2.setFailure(new IllegalStateException(StringUtil.simpleClassName(Http2MultiplexCodec.class) + " must be in the ChannelPipeline of Channel " + this.channel));
            } else {
                promise2.setFailure(new ClosedChannelException());
            }
        } else {
            EventExecutor executor = ctx.executor();
            if (executor.inEventLoop()) {
                this.open0(ctx, promise2);
            } else {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Http2StreamChannelBootstrap.this.open0(ctx, promise2);
                    }
                });
            }
        }
        return promise2;
    }

    public void open0(ChannelHandlerContext ctx, final Promise<Http2StreamChannel> promise2) {
        assert (ctx.executor().inEventLoop());
        final Http2StreamChannel streamChannel = ((Http2MultiplexCodec)ctx.handler()).newOutboundStream();
        try {
            this.init(streamChannel);
        }
        catch (Exception e2) {
            streamChannel.unsafe().closeForcibly();
            promise2.setFailure(e2);
            return;
        }
        ChannelFuture future2 = ctx.channel().eventLoop().register(streamChannel);
        future2.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future2) throws Exception {
                if (future2.isSuccess()) {
                    promise2.setSuccess(streamChannel);
                } else if (future2.isCancelled()) {
                    promise2.cancel(false);
                } else {
                    if (streamChannel.isRegistered()) {
                        streamChannel.close();
                    } else {
                        streamChannel.unsafe().closeForcibly();
                    }
                    promise2.setFailure(future2.cause());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Channel channel) throws Exception {
        ChannelPipeline p = channel.pipeline();
        ChannelHandler handler = this.handler;
        if (handler != null) {
            p.addLast(handler);
        }
        Map<AbstractConstant, Object> map2 = this.options;
        synchronized (map2) {
            Http2StreamChannelBootstrap.setChannelOptions(channel, this.options, logger);
        }
        map2 = this.attrs;
        synchronized (map2) {
            for (Map.Entry<AttributeKey<?>, Object> e2 : this.attrs.entrySet()) {
                channel.attr(e2.getKey()).set(e2.getValue());
            }
        }
    }

    private static void setChannelOptions(Channel channel, Map<ChannelOption<?>, Object> options, InternalLogger logger) {
        for (Map.Entry<ChannelOption<?>, Object> e2 : options.entrySet()) {
            Http2StreamChannelBootstrap.setChannelOption(channel, e2.getKey(), e2.getValue(), logger);
        }
    }

    private static void setChannelOption(Channel channel, ChannelOption<?> option, Object value, InternalLogger logger) {
        try {
            if (!channel.config().setOption(option, value)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", (Object)option, (Object)channel);
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", option, value, channel, t);
        }
    }
}

